/*
 * RuntimeParameters.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Np[^NXB<br>
 * AvP[VNɎw肳ꂽێ܂B<br>
 * <pre>
 * FR\[>java () xxx.ServiceProviderImpl -ServiceName sample -AppParams key1=value1 key2=value2 ...
 * </pre>
 * NɏL̂悤Ȉw肳ꂽꍇA-AppParamsȍ~RuntimeParametersɊi[A
 * {@link RuntimeParameters#get(String)}gpĎ擾邱Ƃł܂B
 * <pre>
 * runtimeParameters.get("key1")  "value1"
 * runtimeParameters.get("key2")  "value2"
 *  c
 * </pre>
 *
 * @author Naoko Sugimoto
 */
public class RuntimeParameters implements Serializable {

	/**
	 * VAo[WID
	 */
	private static final long serialVersionUID = 2577283536937064218L;

	/** Np[^ */
	private Map<String, String> runtimeParameters = null;

	/**
	 * RXgN^B
	 * @param parameterMap Np[^̃}bvBSerializablełȂ΂ȂȂB
	 */
	public RuntimeParameters(Map<String, String> parameterMap) {

		if (parameterMap == null) {
			runtimeParameters = new HashMap<String, String>();
		} else {
			runtimeParameters = parameterMap;
		}
	}

	/**
	 * Np[^Ԃ܂B
	 * @param key Np[^̃L[
	 * @return p[^̒l
	 */
	public String get(String key) {
		return runtimeParameters.get(key);
	}

	/**
	 * w肳ꂽL[Np[^ɑ݂邩ǂ𔻒肵܂B
	 * @param key Np[^̃L[
	 * @return L[݂ꍇtrueA݂Ȃꍇfalse
	 */
	public boolean containsKey(String key) {
		return runtimeParameters.containsKey(key);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		// NXóB
		StringBuilder st = new StringBuilder(this.getClass().getSimpleName());
		// p[^óB
		st.append(runtimeParameters);
		return st.toString();
	}
}
