/*
 * NumberUtil.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;

 /**
  * [eBeBNXB
  * @author Jianming Guo
  */
public class NumberUtil {

	/**
	 * ̏_̌擾܂B
	 *
	 * @param value  
	 * @return _̌
	 */
	public static int getFractionDigits(String value) {
		int  place = 0;

		if(value != null && value.length() > 0){
			String strVal = value.trim();
			place = strVal.lastIndexOf('.') == -1 ? 0 : (strVal.length() - strVal.lastIndexOf('.') - 1);
		}

		return place;
	}

	/**
	 * BigDecimal^Ƀp[X܂B
	 *
	 * @param pattern ̃tH[}bg
	 * @param value   
	 * @return p[XBigDecimal^
	 * @throws NullPointerException <code>pattern</code><code>null</code>̏ꍇɔ܂B
	 * @throws IllegalArgumentException w肳ꂽŃtH[}bgłȂꍇɔ܂B
	 * @throws ParseException w肳ꂽ<code>value</code>Ȃꍇɔ܂B
	 */
	public static BigDecimal parseBigDecimal(String pattern, String value) throws NullPointerException, IllegalArgumentException, ParseException {

		DecimalFormat df = new DecimalFormat();
		df.applyPattern(pattern);
		df.setParseBigDecimal(true);

		return (BigDecimal)df.parse(value);
	}

	/**
	 * tH[}bg܂B
	 *
	 * @param pattern ̃tH[}bg
	 * @param value   
	 * @return tH[}bg̕
	 * @throws NullPointerException <code>pattern</code><code>null</code>̏ꍇɔ܂B
	 * @throws IllegalArgumentException w肳ꂽŃtH[}bgłȂꍇɔ܂B
	 */
	public static String formatNumber(String pattern, String value) throws NullPointerException, IllegalArgumentException {
		DecimalFormat df = new DecimalFormat();
		df.applyPattern(pattern);

		return  df.format(new BigDecimal(value));
	}

	/**
	 * BigDecimal^w̏̕ɕϊ܂B
	 *  ľܓ
	 *
	 * @param value BigDecimal^
	 * @param fractionDigits ̌
	 * @return ϊ̕
	 */
	public static String numberToString(BigDecimal value, int fractionDigits) {
		if (value == null) {
			return null;
		}

		DecimalFormat df = new DecimalFormat();
		df.setGroupingUsed(false);
		df.setMaximumFractionDigits(fractionDigits);

		return df.format(value);
	}
}
