/*
 * ValidationErrorHandler.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * XMLXL[}XMLt@CÓ؃G[nhNXB<br>
 * @author Jianming Guo
 */
public class ValidationErrorHandler implements ErrorHandler {
	/** O */
	private static final Log LOG = LogFactory.getLog(ValidationErrorHandler.class);

	/**
	 * Ó،:trueL  falseG[
	 */
	private boolean isValid = true;

	/**
	 * Ó،ʂԂ܂B
	 *
	 * @return Ó،
	 */
	public boolean isValid() {
		return isValid;
	}

	/**
	 * XMLp[T̒vȃG[B
	 *
	 * @param exception SAX\͗O
	 * @throws SAXException SAX O
	 */
	public void error(SAXParseException exception) throws SAXException {
		LOG.error("(" + getSystemId(exception)
				+ ":" + exception.getLineNumber() + ") "
				+ exception.getMessage());

		isValid = false;
	}

	/**
	 * XMLp[T̒vȃG[B
	 *
	 * @param exception SAX\͗O
	 * @throws SAXException SAX O
	 */
	public void fatalError(SAXParseException exception)  throws SAXException {
		LOG.error("(" + getSystemId(exception)
				+ ":" + exception.getLineNumber() + ") "
				+ exception.getMessage());

		isValid = false;
	}

	/**
	 * XMLp[ŤxG[B
	 *
	 * @param exception SAX\͗O
	 * @throws SAXException SAX O
	 */
	public void warning(SAXParseException exception)  throws SAXException {
		LOG.error("(" + getSystemId(exception)
				+ ":" + exception.getLineNumber() + ") "
				+ exception.getMessage());

		isValid = false;
	}

	/**
	 * SAXÕVXeID̃t@Ĉ݂擾܂B
	 *
	 * @param exception SAX\͗O
	 * @return t@C
	 */
	private String getSystemId(SAXParseException exception) {
		String systemId = exception.getSystemId();
		return systemId == null ? "" : systemId.substring(systemId.lastIndexOf('/') + 1);
	}
}
