/*
 * LogMessageFactory.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import jp.co.cybec.cb3.exception.MessageResourceException;

/**
 * bZ[WIDL[ɂăbZ[W擾邽߂̃NXłB
 * @author Naoko Sugimoto
 */
public class LogMessageFactory {

	/** \[Xoh */
	private ResourceBundle bundle = null;
	/** vpeBt@C */
	private String propertyFileName = null;

	/**
	 * RXgN^B
	 *
	 * @param propertyFileName vpeBt@C
	 * @throws MessageResourceException bZ[WvpeBt@CNXpXɌȂꍇB
	 */
	public LogMessageFactory(String propertyFileName) throws MessageResourceException {
		try {
			bundle = ResourceBundle.getBundle(propertyFileName);
		} catch (MissingResourceException e) {
			throw new MessageResourceException("[" + propertyFileName + ".properties]NXpXɌ܂B", e);
		}
		this.propertyFileName = propertyFileName;
	}

	/**
	 * bZ[WIDw肵ăbZ[W擾܂B
	 *
	 * @param messageId bZ[WID
	 * @return bZ[W
	 */
	public String getMessage(String messageId) {
		try {
			//"MessageID:[XXXX] bZ[WeB"
			StringBuilder message = new StringBuilder();
			message.append(getMessageIdentifier());
			message.append("MessageID:[");
			message.append(messageId);
			message.append("] ");
			message.append(bundle.getString(messageId));
			return message.toString();
		} catch (MissingResourceException e) {
			return "bZ[WID[" + messageId + "][" + propertyFileName + ".properties]Ɍ܂B";
		}
	}

	/**
	 * bZ[WIDw肵ăbZ[W擾܂B
	 *
	 * @param messageId bZ[WID
	 * @param args u
	 * @return bZ[W
	 */
	public String getMessage(String messageId, Object... args) {
		try {
			//"MessageID:[XXXX] bZ[WeB"
			StringBuilder message = new StringBuilder();
			message.append(getMessageIdentifier());
			message.append("MessageID:[");
			message.append(messageId);
			message.append("] ");
			message.append(bundle.getString(messageId));
			return MessageFormat.format(message.toString(), args);
		} catch (MissingResourceException e) {

			//"bZ[WID[XXXX][xxxx.properties]Ɍ܂BbZ[WF[xx, xxx, ...]"
			StringBuilder message = new StringBuilder();
			message.append("bZ[WID[");
			message.append(messageId);
			message.append("][");
			message.append(propertyFileName);
			message.append(".properties]Ɍ܂BbZ[WF[");
			for (Object arg: args) {
				message.append(arg);
				message.append(", ");
			}
			// ́u,v폜B
			if (message.lastIndexOf(", ") == message.length() - 2) {
				message.delete(message.length() - 2, message.length());
			}
			message.append("]");
			return message.toString();
		}
	}

	/**
	 * G[R[hƃbZ[WIDw肵ăbZ[W擾܂B
	 *
	 * @param errorCode G[R[h
	 * @param messageId bZ[WID
	 * @return bZ[W
	 */
	public String getErrorMessage(String errorCode, String messageId) {
		try {
			//"ErrorCode:[XXXX] MessageID:[XXXX] bZ[WeB"
			StringBuilder message = new StringBuilder();
			message.append(getMessageIdentifier());
			message.append("ErrorCode:[");
			message.append(errorCode);
			message.append("] ");
			message.append("MessageID:[");
			message.append(messageId);
			message.append("] ");
			message.append(bundle.getString(messageId));
			return message.toString();
		} catch (MissingResourceException e) {
			return "bZ[WID[" + messageId + "][" + propertyFileName + ".properties]Ɍ܂B";
		}
	}

	/**
	 * G[R[hƃbZ[WIDw肵ăbZ[W擾܂B
	 *
	 * @param errorCode G[R[h
	 * @param messageId bZ[WID
	 * @param args u
	 * @return bZ[W
	 */
	public String getErrorMessage(String errorCode, String messageId, Object... args) {
		try {
			//"ErrorCode:[XXXX] MessageID:[XXXX] bZ[WeB"
			StringBuilder message = new StringBuilder();
			message.append(getMessageIdentifier());
			message.append("ErrorCode:[");
			message.append(errorCode);
			message.append("] ");
			message.append("MessageID:[");
			message.append(messageId);
			message.append("] ");
			message.append(bundle.getString(messageId));
			return MessageFormat.format(message.toString(), args);
		} catch (MissingResourceException e) {

			//"bZ[WID[XXXX][xxxx.properties]Ɍ܂BbZ[WF[xx, xxx, ...]"
			StringBuilder message = new StringBuilder();
			message.append("bZ[WID[");
			message.append(messageId);
			message.append("][");
			message.append(propertyFileName);
			message.append(".properties]Ɍ܂BbZ[WF[");
			for (Object arg: args) {
				message.append(arg);
				message.append(", ");
			}
			// ́u,v폜B
			if (message.lastIndexOf(", ") == message.length() - 2) {
				message.delete(message.length() - 2, message.length());
			}
			message.append("]");
			return message.toString();
		}
	}

	/**
	 * bZ[Wʎq擾܂B<br>
	 * pbP[Wɂ艺L̂悤ɏo͌`ς܂B
	 * <pre>
	 * CorepbP[Wł̏o͌`F"JobProcessID:[XXXX] ServiceID:[XXXX] "
	 * AdvancedpbP[Wł̏o͌`F"JobProcessID:[XXXX] JobID:[XXXX] TaskID:[XXXX] ServiceID:[XXXX] "
	 * </pre>
	 *
	 * @return bZ[Wʎq
	 * @see LogMessageIdentifier
	 */
	private String getMessageIdentifier() {
		StringBuilder message = new StringBuilder();
		if (LogMessageIdentifier.getJobProcessId() != null) {
			message.append("JobProcessID:[");
			message.append(LogMessageIdentifier.getJobProcessId());
			message.append("] ");
		}
		if (LogMessageIdentifier.getJobId() != null) {
			message.append("JobID:[");
			message.append(LogMessageIdentifier.getJobId());
			message.append("] ");
		}
		if (LogMessageIdentifier.getTaskId() != null) {
			message.append("TaskID:[");
			message.append(LogMessageIdentifier.getTaskId());
			message.append("] ");
		}
		if (LogMessageIdentifier.getServiceId() != null) {
			message.append("ServiceID:[");
			message.append(LogMessageIdentifier.getServiceId());
			message.append("] ");
		}
		return message.toString();
	}

}
