/*
 * DataAccessContextImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor;

import java.util.HashMap;
import java.util.Map;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.accessor.DataAccessContext;
import jp.co.cybec.cb3.accessor.DataAccessContextImpl;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.mock.accessor.MockAccessor;
import jp.co.cybec.cb3.mock.accessor.MockAccessorThrowException;
import junit.framework.Assert;

import org.junit.Test;

/**
 * DataAccessContextImpl̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class DataAccessContextImplTest {

	/**
	 * {@link jp.co.cybec.cb3.accessor.DataAccessContextImpl#DataAccessContextImpl(java.util.Map)} ̂߂̃eXgE\bhB
	 * DataAccessContextImpl̃RXgN^ŃANZbT̏sĂ邱ƂmFB
	 */
	@Test
	public void testDataAccessContextImpl() {

		// _~[̃ANZbT𐶐B
		MockAccessor accessor1 = new MockAccessor();
		MockAccessor accessor2 = new MockAccessor();

		// ANZbTMapɊi[B
		Map<String, Accessor> accessors = new HashMap<String, Accessor>();
		accessors.put("accessor1", accessor1);
		accessors.put("accessor2", accessor2);

		// DataAccessContextImpl𐶐B
		DataAccessContext dataAccessContext = new DataAccessContextImpl(accessors);

		// ANZbT擾B
		accessor1 = (MockAccessor)dataAccessContext.lookup("accessor1");
		accessor2 = (MockAccessor)dataAccessContext.lookup("accessor2");

		// ANZbTĂ邱ƂmFB
		Assert.assertTrue(accessor1.isInitialized());
		Assert.assertTrue(accessor2.isInitialized());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.DataAccessContextImpl#DataAccessContextImpl(java.util.Map)} ̂߂̃eXgE\bhB
	 * ANZbT̏ɎsƂAK؂ȗO邱ƂmFB
	 * {@link ConfigFileDefinitionException}̏ꍇB
	 */
	@Test(expected=ConfigFileDefinitionException.class)
	public void testDataAccessContextImplThrowException() {

		// _~[̃ANZbT𐶐B
		MockAccessorThrowException accessor1 = new MockAccessorThrowException();
		accessor1.setException(new ConfigFileDefinitionException("ÕeXgłB"));

		// ANZbTMapɊi[B
		Map<String, Accessor> accessors = new HashMap<String, Accessor>();
		accessors.put("accessor1", accessor1);

		// DataAccessContextImpl𐶐B
		new DataAccessContextImpl(accessors);
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.DataAccessContextImpl#DataAccessContextImpl(java.util.Map)} ̂߂̃eXgE\bhB
	 * ANZbT̏ɎsƂAK؂ȗO邱ƂmFB
	 * \ȂG[̏ꍇB
	 */
	@Test(expected=AccessorUnknownException.class)
	public void testDataAccessContextImplThrowUnknownException() {

		// _~[̃ANZbT𐶐B
		MockAccessorThrowException accessor1 = new MockAccessorThrowException();
		accessor1.setException(new NullPointerException("ÕeXgłB"));

		// ANZbTMapɊi[B
		Map<String, Accessor> accessors = new HashMap<String, Accessor>();
		accessors.put("accessor1", accessor1);

		// DataAccessContextImpl𐶐B
		new DataAccessContextImpl(accessors);
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.DataAccessContextImpl#lookup(java.lang.String)} ̂߂̃eXgE\bhB
	 * lookup\bhœK؂ȃANZbT擾ł邱ƂmFB
	 */
	@Test
	public void testLookup() {

		// _~[̃ANZbT𐶐B
		Accessor accessor1 = new MockAccessor();
		Accessor accessor2 = new MockAccessor();

		// ANZbTMapɊi[B
		Map<String, Accessor> accessors = new HashMap<String, Accessor>();
		accessors.put("accessor1", accessor1);
		accessors.put("accessor2", accessor2);

		// DataAccessContextImpl𐶐B
		DataAccessContext dataAccessContext = new DataAccessContextImpl(accessors);

		// lookupŎ擾ANZbTACX^XƓ̂ł邱ƂmFB
		Assert.assertSame(accessor1, dataAccessContext.lookup("accessor1"));
		Assert.assertSame(accessor2, dataAccessContext.lookup("accessor2"));
	}


	/**
	 * {@link jp.co.cybec.cb3.accessor.DataAccessContextImpl#lookup(java.lang.String)} ̂߂̃eXgE\bhB
	 * lookup\bhɎw肵bean݂ȂꍇAK؂ȗO邱ƂmFB
	 */
	@Test(expected=ConfigFileDefinitionException.class)
	public void testLookupNoBean() {

		// _~[̃ANZbT𐶐B
		Accessor accessor1 = new MockAccessor();
		Accessor accessor2 = new MockAccessor();

		// ANZbTMapɊi[B
		Map<String, Accessor> accessors = new HashMap<String, Accessor>();
		accessors.put("accessor1", accessor1);
		accessors.put("accessor2", accessor2);

		// DataAccessContextImpl𐶐B
		DataAccessContext dataAccessContext = new DataAccessContextImpl(accessors);

		// ݂ȂL[lookupɎwB
		Assert.assertSame(accessor1, dataAccessContext.lookup("dummy"));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.DataAccessContextImpl#release()} ̂߂̃eXgE\bhB
	 * release()\bhɂāAANZbT̏IĂ΂Ă邱ƂmFB
	 */
	@Test
	public void testRelease() {
		// _~[̃ANZbT𐶐B
		MockAccessor accessor1 = new MockAccessor();
		MockAccessor accessor2 = new MockAccessor();

		// ANZbTMapɊi[B
		Map<String, Accessor> accessors = new HashMap<String, Accessor>();
		accessors.put("accessor1", accessor1);
		accessors.put("accessor2", accessor2);

		// DataAccessContextImpl𐶐B
		DataAccessContextImpl dataAccessContext = new DataAccessContextImpl(accessors);

		// DataAccessContextImplIB
		dataAccessContext.release();

		// ANZbT̏IĂ΂Ă邱ƂmFB
		Assert.assertTrue(accessor1.isReleased());
		Assert.assertTrue(accessor2.isReleased());
	}
}
