/*
 * DBAccessConfigTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig;
import jp.co.cybec.cb3.accessor.dbaccess.DeleteSql;
import jp.co.cybec.cb3.accessor.dbaccess.InsertSql;
import jp.co.cybec.cb3.accessor.dbaccess.SelectSql;
import jp.co.cybec.cb3.accessor.dbaccess.UpdateSql;

import org.junit.Assert;
import org.junit.Test;



/**
 *
 * DBAccessConfigNX̃eXgP[X
 *
 * @author Lijuan Sun
 */
public class DBAccessConfigTest {

	DBAccessConfig dbaAccessConfig = new DBAccessConfig();

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * NG[pSQL擾\bheXg
	 */
	@Test
	public void testGetSelectSql001() {

		for(int i = 0; i < 5; i++){
			dbaAccessConfig.setSelectSql(new SelectSql());
		}
		Assert.assertEquals(5, dbaAccessConfig.getSelectSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * nullݒ肳ꍇ
	 */
	@Test
	public void testGetSelectSql002() {

		dbaAccessConfig.setSelectSql(null);

		Assert.assertNull( dbaAccessConfig.getSelectSql().get(0));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * NG[pSQLݒ胁\bheXg
	 */
	@Test
	public void testSetSelectSql() {

		for(int i = 0; i < 1; i++){
			dbaAccessConfig.setSelectSql(new SelectSql());
		}
		Assert.assertEquals(1, dbaAccessConfig.getSelectSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * XVpSQL擾\bheXg
	 */
	@Test
	public void testGetUpdateSql() {

		for(int i = 0; i < 0; i++){
			dbaAccessConfig.setUpdateSql(new UpdateSql());
		}
		Assert.assertEquals(0, dbaAccessConfig.getUpdateSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * nullݒ肳ꍇ
	 */
	@Test
	public void testGetUpdateSql002() {

		dbaAccessConfig.setUpdateSql(null);

		Assert.assertNull( dbaAccessConfig.getUpdateSql().get(0));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * XVpSQLݒ胁\bheXg
	 */
	@Test
	public void testSetUpdateSql() {

		for(int i = 0; i < 1; i++){
			dbaAccessConfig.setUpdateSql(new UpdateSql());
		}
		Assert.assertEquals(1, dbaAccessConfig.getUpdateSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * CT[gpSQL擾\bheXg
	 */
	@Test
	public void testGetInsertSql() {

		for(int i = 0; i < 1; i++){
			dbaAccessConfig.setInsertSql(new InsertSql());
		}
		Assert.assertEquals(1, dbaAccessConfig.getInsertSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * nullݒ肳ꍇ
	 */
	@Test
	public void testGetInsertSql002() {

		dbaAccessConfig.setInsertSql(null);

		Assert.assertNull( dbaAccessConfig.getInsertSql().get(0));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * CT[gpSQLݒ胁\bheXg
	 */
	@Test
	public void testSetInsertSql() {

		for(int i = 0; i < 1; i++){
			dbaAccessConfig.setInsertSql(new InsertSql());
		}
		Assert.assertEquals(1, dbaAccessConfig.getInsertSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * 폜pSQL擾\bheXg
	 */
	@Test
	public void testGetDeleteSql() {

		for(int i = 0; i < 100; i++){
			dbaAccessConfig.setDeleteSql(new DeleteSql());
		}
		Assert.assertEquals(100, dbaAccessConfig.getDeleteSql().size());
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * nullݒ肳ꍇ
	 */
	@Test
	public void testGetDeleteSql002() {

		dbaAccessConfig.setDeleteSql(null);

		Assert.assertNull( dbaAccessConfig.getDeleteSql().get(0));
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
	 * CT[gpSQLݒ胁\bheXg
	 */
	@Test
	public void testSetDeleteSql() {

		for(int i = 0; i < 10; i++){
			dbaAccessConfig.setDeleteSql(new DeleteSql());
		}
		Assert.assertEquals(10, dbaAccessConfig.getDeleteSql().size());
	}

//	/**
//	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
//	 * R~bgPʂ擾\bheXg
//	 */
//	@Test
//	public void testGetCommitLimitCount() {
//
//		dbaAccessConfig.setCommitLimitCount(1000);
//		Assert.assertEquals(1000, dbaAccessConfig.getCommitLimitCount());
//	}
//
//	/**
//	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
//	 * R~bgPʂݒ胁\bheXg
//	 */
//	@Test
//	public void testSetCommitLimitCount() {
//
//		dbaAccessConfig.setCommitLimitCount(0);
//		Assert.assertEquals(0, dbaAccessConfig.getCommitLimitCount());
//	}
//
//	/**
//	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
//	 * R~bgPʃtOeXg
//	 */
//	@Test
//	public void testGetCommitLimitCountFlg() {
//
//		dbaAccessConfig.setCommitLimitCount(10);
//		Assert.assertTrue(dbaAccessConfig.getCommitFlg());
//	}
//
//	/**
//	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig} ̂߂̃eXgE\bhB
//	 * R~bgPʃtOeXg
//	 */
//	@Test
//	public void testGetCommitLimitCountFlg02() {
//
//		dbaAccessConfig.setCommitLimitCount(00);
//		Assert.assertFalse(dbaAccessConfig.getCommitFlg());
//	}
}
