/*
 * DBAccessorImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.DataFileNoSuchSqlIdException;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/**
*
* DBAccessorImplNX̃eXgP[X
*
* @author Lijuan Sun
*/
public class DBAccessorImplTest {
	// ݒt@Cp[X
	private static String[] CONTEXT_XML_PATH = new String[] {
			"jp/co/cybec/cb3/accessor/dbaccess/TestDBAccessConfig.xml",
			"datasourceContext.xml",
			"transactionContext.xml"};

	// ϐ
	ApplicationContext context = new ClassPathXmlApplicationContext(CONTEXT_XML_PATH);
	// NXCX^X
	DBAccessorImpl dbaccessTmp = (DBAccessorImpl) context.getBean("dbAccessorImpl");
	DBQueryParameterMap parameter = null;
	DataSourceTransactionManager txManager;
	TransactionStatus status;

	@Before
	public void setup() throws Exception {

		// gUNVJn܂
		startTransaction();

		// e[uNA
		dbaccessTmp.delete("delete1");

	}

	@After
	public void tearDown() throws Exception {

		// R~bg܂B
		commit();

	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * NG[\bheXgB
	 * (p[^tꍇ)
	 *
	 */
	@Test
	public void testSelect01() {

		DBRecord record = null;

		try {
			// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			dbaccessTmp.insert("insert1", parameter);
			// f[^擾
			DBRecordReader recordReader = dbaccessTmp.select("select1", parameter);
			Assert.assertNotNull(recordReader);
			// ʂ`FbN
			while ((record = recordReader.nextRecord()) != null) {
				Assert.assertEquals("tst01", record.getString("EMP_CODE"));
				Assert.assertEquals("abcde", record.getString("EMP_NAME"));
			}
		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[g\bheXgB
	 * (p[^tꍇ)
	 *
	 */
	@Test
	public void testInsert01() {

		try {
			// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			// ʂ`FbN
			Assert.assertEquals(1, dbaccessTmp.insert("insert1", parameter));
		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bheXgB
	 * (p[^tꍇ)
	 *
	 */
	@Test
	public void testUpdate01() {

		String empCd = null;

		try {
			// p[^ݒ肷
			for (int i = 0; i < 6; i++) {
				empCd = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", empCd);
				// f[^CT[g
				dbaccessTmp.insert("insert1", parameter);
			}
			// XVpp[^ݒ肷
			parameter.clear();
			parameter.put("EMP_CODE", "tst01");
			parameter.put("EMP_NAME", "UPDATE1");
			// ʂ`FbN
			Assert.assertEquals(1, dbaccessTmp.update("update1", parameter));

		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜\bheXgB
	 * (p[^tꍇ)
	 *
	 */
	@Test
	public void testDelete01() {

		String empCd = null;

		try {
			// p[^ݒ肷
			for (int i = 0; i < 5; i++) {
				empCd = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", empCd);
				// f[^CT[g
				dbaccessTmp.insert("insert1", parameter);
			}
			// 폜pp[^ݒ肷
			parameter.clear();
			parameter.put("EMP_CODE", "tst01");
			// ʂ`FbN
			Assert.assertEquals(1, dbaccessTmp.delete("delete2", parameter));

		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * NG[\bheXgB
	 * (p[^tȂꍇ)
	 *
	 */
	@Test
	public void testSelect02() {

		DBRecord record = null;

		try {
			// p[^ݒ肷
			parameter.put("EMP_CODE", "tst01");

			// f[^CT[g
			dbaccessTmp.insert("insert1", parameter);
			// f[^擾
			DBRecordReader recordReader = dbaccessTmp.select("select2");
			// ʂ`FbN
			while ((record = recordReader.nextRecord()) != null) {
				Assert.assertEquals(1, record.getInteger("count").intValue());
			}
		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[g\bheXgB
	 * (p[^tȂꍇ)
	 *
	 */
	@Test
	public void testInsert02() {

		try {
			// f[^CT[g
			// ʂ`FbN
			Assert.assertEquals(1, dbaccessTmp.insert("insert2"));
		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bheXgB
	 * (p[^tȂꍇ)
	 *
	 */
	@Test
	public void testUpdate02() {

		String empCd = null;

		try {
			// p[^ݒ肷
			for (int i = 0; i < 5; i++) {
				empCd = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", empCd);
				// f[^CT[g
				dbaccessTmp.insert("insert1", parameter);
			}
			// ʂ`FbN
			Assert.assertEquals(5, dbaccessTmp.update("update2"));

		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bheXgB
	 * (p[^tȂꍇ)
	 *
	 */
	@Test
	public void testDelete02() {

		String empCd = null;

		try {
			// p[^ݒ肷
			for (int i = 0; i < 5; i++) {
				empCd = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", empCd);
				// f[^CT[g
				dbaccessTmp.insert("insert1", parameter);
			}
			// ʂ`FbN
			Assert.assertEquals(5, dbaccessTmp.delete("delete1"));
		} catch (DataAccessException e) {
			e.printStackTrace();
			Assert.fail("eXgs");
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * NG[\bhɃG[ꍇ
	 *
	 */
	@Test
	public void testSelect03() {

		try {
			// f[^擾SQLs
			dbaccessTmp.select("select3");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bhɃG[ꍇ
	 *
	 */
	@Test
	public void testUpdate03() {

		try {
			// f[^XVSQLs
			dbaccessTmp.update("update3");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜\bhɃG[ꍇ
	 *
	 */
	@Test
	public void testDelete03() {

		try {
			// f[^폜SQLs
			dbaccessTmp.delete("delete3");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[g\bhɃG[ꍇ
	 *
	 */
	@Test
	public void testInsert03() {

		try {
			// f[^CT[gSQLs
			dbaccessTmp.insert("insert1", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[g\bheXgB
	 * (R~bgPʂw肵ĂAp[^tꍇ)
	 */
	@Test
	public void testInsert04() throws Exception {

		String code = null;
		try {
			for (int i = 0; i < 8; i++) {

				// p[^ݒ肷
				code = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", code);

				// 7ڃG[
				if (i == 6) {
					// p[^NA
					parameter.clear();
				}
				// f[^CT[g
				dbaccessTmp.insert("insert4", parameter);
			}

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
			rollback();
		} finally {
			// f[^mF邽߂ɃgUNVJn܂B
			startTransaction();
			// ʂ`FbN
			// \zFTCT[g
			Assert.assertEquals(5, dbaccessTmp.delete("delete1"));
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bheXgB
	 * (R~bgPʂw肵ĂAp[^tꍇ)
	 *
	 */
	@Test
	public void testUpdate04() {

		String code = null;
		String name = "testName";

		try {
			// POeXgf[^쐬
			for (int i = 0; i < 10; i++) {
				// p[^ݒ肷
				code = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", code);
				dbaccessTmp.insert("insert4", parameter);
			}

			parameter.clear();
			// 3R~bgA1[obN
			for (int i = 0; i < 6; i++) {
				code = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", code);
				parameter.put("EMP_NAME", name);
				// 5ڃG[
				if (i == 4) {
					// p[^NA
					parameter.clear();
				}
				// XV
				dbaccessTmp.update("update4", parameter);
			}

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
			rollback();
		} finally {
			// f[^mF邽߂ɃgUNVJn܂B
			startTransaction();
			// ʂ`FbN
			parameter.clear();
			parameter.put("EMP_NAME", name);
			// \zF3XV
			Assert.assertEquals(3, dbaccessTmp.delete("delete6", parameter));
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜\bheXgB
	 * (R~bgPʂw肵ĂAp[^tꍇ)
	 *
	 */
	@Test
	public void testdelete04() {

		String code = null;

		try {
			// POeXgf[^쐬
			for (int i = 0; i < 10; i++) {
				// p[^ݒ肷
				code = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", code);
				dbaccessTmp.insert("insert4", parameter);
			}

			parameter.clear();
			// 4R~bgA1[obN
			for (int i = 0; i < 6; i++) {
				code = "tst0" + String.valueOf(i);
				parameter.put("EMP_CODE", code);
				// UڃG[
				if (i == 5) {
					// p[^NA
					parameter.clear();
				}
				// 폜
				dbaccessTmp.delete("delete4", parameter);
			}

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
			rollback();
		} finally {
			// f[^mF邽߂ɃgUNVJn܂B
			startTransaction();
			// ʂ`FbN
			// \zF6폜
			Assert.assertEquals(6, dbaccessTmp.delete("delete1"));
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[g\bheXgB
	 * (R~bgPʂw肵ĂAp[^tĂȂꍇ)
	 *
	 */
	@Test
	public void testInsert05() {

		try {
			for (int i = 0; i < 3; i++) {

				// f[^CT[g
				// QڃG[
				dbaccessTmp.insert("insert5");
			}
		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		} finally {
			// ʂ`FbN
			Assert.assertEquals(1, dbaccessTmp.delete("delete1"));
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bheXgB
	 * (R~bgPʂw肵ĂAp[^tĂȂꍇ)
	 *
	 */
	@Test
	public void testUpdate05() {

		try {
			dbaccessTmp.update("update5");
		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜\bheXgB
	 * (R~bgPʂw肵ĂAp[^tĂȂꍇ)
	 *
	 */
	@Test
	public void testDelete05() {

		try {
			dbaccessTmp.delete("delete5");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataAccessException)) {
				Assert.fail("eXgs");
			}
		} finally {
			// ʂ`FbN
			Assert.assertEquals(0, dbaccessTmp.delete("delete1"));
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl#insert(String)} ̂߂̃eXgE\bhB
	 * ݒt@CɋLq~Xꍇ̃eXgB
	 * R~bgɐȊO̕w肵ĂꍇɁAK؂ȗO邱ƂmFB
	 */
	@Test
	public void testInsert06() {

		try {
			// f[^CT[gSQLs
			dbaccessTmp.insert("insert6");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				System.out.println(e);
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bhɂ̑G[ꍇ
	 *
	 */
	@Test
	@Ignore
	public void testUpdate06() {

		try {
			// f[^XVSQLs
			dbaccessTmp.update("update6");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof AccessorUnknownException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜\bhɂ̑G[ꍇ
	 *
	 */
	@Test
	@Ignore
	public void testDelete06() {

		try {
			// f[^폜SQLs
			dbaccessTmp.delete("delete7");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof AccessorUnknownException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[g\bhɂ̑G[ꍇ
	 *
	 */
	@Test
	@Ignore
	public void testInsert07() {

		try {
			// f[^CT[gSQLs
			parameter.put("EMP_CODE", "tst01");
			dbaccessTmp.insert("insert7", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof AccessorUnknownException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XV\bhɂ̑G[ꍇ
	 *
	 */
	@Test
	@Ignore
	public void testUpdate07() {

		try {
			// f[^XVSQLs
			parameter.put("EMP_CODE", "tst01");
			dbaccessTmp.update("update7", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof AccessorUnknownException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜\bhɂ̑G[ꍇ
	 *
	 */
	@Test
	@Ignore
	public void testDelete07() {

		try {
			// f[^폜SQLs
			parameter.put("EMP_CODE", "tst01");
			dbaccessTmp.delete("delete8", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof AccessorUnknownException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * ݒt@CǂݍރG[ꍇ
	 */
	@Test
	public void testInitial() {
		try {
			// badݒt@Cǂݍ
			dbaccessTmp.initialize("jp/co/cybec/cb3/accessor/dbaccess/TestDBAccessConfig");
		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof ConfigFileDefinitionException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * NG[SQLNULLꍇ
	 *
	 */
	@Test
	public void testSelect08() {

		try {
			// f[^擾SQLs
			dbaccessTmp.select("aa", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[gSQLNULLꍇ
	 *
	 */
	@Test
	public void testInsert08() {

		try {
			// f[^CT[gSQLs
			dbaccessTmp.insert("aa", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XVSQLNULLꍇ
	 *
	 */
	@Test
	public void testUpdate08() {

		try {
			// f[^XVSQLs
			dbaccessTmp.update("aa", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜SQLNULLꍇ
	 *
	 */
	@Test
	public void testDelete08() {

		try {
			// f[^폜SQLs
			dbaccessTmp.delete("aa", parameter);

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * NG[SQLNULLꍇ
	 *
	 */
	@Test
	public void testSelect09() {

		try {
			// f[^擾SQLs
			dbaccessTmp.select("aa");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * CT[gSQLNULLꍇ
	 *
	 */
	@Test
	public void testInsert09() {

		try {
			// f[^CT[gSQLs
			dbaccessTmp.insert("aa");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * XVSQLNULLꍇ
	 *
	 */
	@Test
	public void testUpdate09() {

		try {
			// f[^XVSQLs
			dbaccessTmp.update("aa");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 *
	 * {@link jp.co.cybec.cb3.accessor.dbaccess.DBAccessorImpl} ̂߂̃eXgE\bhB
	 * 폜SQLNULLꍇ
	 *
	 */
	@Test
	public void testDelete09() {

		try {
			// f[^폜SQLs
			dbaccessTmp.delete("aa");

		} catch (Exception e) {
			// ʃ`FbN
			if (!(e instanceof DataFileNoSuchSqlIdException)) {
				Assert.fail("eXgs");
			}
		}
	}

	/**
	 * gUNVJn܂B
	 */
	private void startTransaction() {

		// gUNVJn܂B
		txManager = (DataSourceTransactionManager) context.getBean("transactionManager");
		DefaultTransactionDefinition def = new DefaultTransactionDefinition();
		def.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
		status = txManager.getTransaction(def);

		// ݒt@Cǂݍ
		dbaccessTmp.initialize("jp/co/cybec/cb3/accessor/dbaccess/dbaccessConfig");

		// p[^ݒ肷
		parameter = new DBQueryParameterMap();
		parameter.put("EMP_NAME", "abcde");
		parameter.put("EMP_CELLULAR_PHONE", "123456789");
		parameter.put("EMP_BIRTH", "19800101");
		parameter.put("EMP_SEX", "1");
	}

	/**
	 * R~bg܂B
	 */
	private void commit() {

		// [X
		dbaccessTmp.release();

		// R~bg
		if (!status.isCompleted()) {
			txManager.commit(status);
		}
	}

	/**
	 * [obN܂B
	 */
	private void rollback() {

		// [X
		dbaccessTmp.release();

		// [obN
		if (!status.isCompleted()) {
			txManager.rollback(status);
		}
	}
}
