/*
 * RecordFieldReaderFormatTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess;


import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormat;
import jp.co.cybec.cb3.exception.DataFormatException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link RecordFieldReaderFormat} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class RecordFieldReaderFormatTest {

	RecordFieldReaderFormat target = null;

	@Before
	public void setUp() throws Exception {
		target = new RecordFieldReaderFormat("c:\testConfig.xml", "fieldName");
	}

	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * tH[}bg邱ƂmFB
	 *   f[^^FAp^[F"#,###.00"
	 */
	@Test
	public void testFormat01() {
		String result = target.format("#,###.00", RecordFieldConstants.TYPE_NUMBER, "123,456.20");
		Assert.assertEquals("123456.2", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * tH[}bg邱ƂmFB
	 *   f[^^FtAp^[F"yyyyMMdd"
	 */
	@Test
	public void testFormat02() {
		String result = target.format("yyyyMMdd", RecordFieldConstants.TYPE_DATE, "20081023");
		Assert.assertEquals("2008/10/23 00:00:00", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * tH[}bg邱ƂmFB
	 *   f[^^FtAp^[F"yyyy-MM-dd"
	 */
	@Test
	public void testFormat03() {
		String result = target.format("yyyy-MM-dd", RecordFieldConstants.TYPE_DATE, "2008-10-23");
		Assert.assertEquals("2008/10/23 00:00:00", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * tH[}bg邱ƂmFB
	 *   f[^^FtAp^[F"MM-dd-yy"
	 */
	@Test
	public void testFormat04() {
		String result = target.format("MM-dd-yy", RecordFieldConstants.TYPE_DATE, "10-23-08");
		Assert.assertEquals("2008/10/23 00:00:00", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * f[^w̏ꍇAtH[}bgȂƂmFB
	 *   f[^^FAp^[F"###"Af[^Fnull
	 */
	@Test
	public void testFormat05() {
		// f[^Fnull
		String result = target.format("###", RecordFieldConstants.TYPE_NUMBER, null);
		Assert.assertEquals(null, result);

		// f[^F"";
		result = target.format("###", RecordFieldConstants.TYPE_NUMBER, "");
		Assert.assertEquals("", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * p^[w̏ꍇAtH[}bgȂƂmFB
	 */
	@Test
	public void testFormat06() {
		// p^[Fnull;
		String result = target.format(null, RecordFieldConstants.TYPE_NUMBER, "123.1000");
		Assert.assertEquals("123.1000", result);

		// p^[F""
		result = target.format("", RecordFieldConstants.TYPE_NUMBER, "123.1000");
		Assert.assertEquals("123.1000", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * ^Cvw̏ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException01() {
		target.format("###", null, "123");
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * f[^ȂꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException02() {
		target.format("###", RecordFieldConstants.TYPE_NUMBER, "#123");
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * ^Cvnull̏ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException03() {
		target.format("###", null, "123");
	}

	/**
	 * {@link RecordFieldReaderFormat#format(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * ^CvunumbervƁudatevȊȌꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException04() {
		target.format("###", "center", "123");
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * f[^null̏ꍇAnullԂƂmFB
	 */
	@Test
	public void testTrim01() {
		String result = target.trim(RecordFieldConstants.ALGIN_LEFT, "0", null);
		Assert.assertNull(result);
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * ACgw̏ꍇAgȂƂmFB
	 */
	@Test
	public void testTrim02() {
		// ACgFnull
		String result = target.trim(null, "0", "012300");
		Assert.assertEquals("012300", result);

		// ACgF""
		result = target.trim("", "0", "012300");
		Assert.assertEquals("012300", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * g邱ƂmFB
	 *   pfBOF" "AACgF"left"Af[^F" L    "
	 */
	@Test
	public void testTrim03() {
		String result = target.trim(RecordFieldConstants.ALGIN_LEFT, " ", " L    ");
		Assert.assertEquals(" L", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * g邱ƂmFB
	 *   pfBOF"0"AACgF"right"Af[^F"0001020"
	 */
	@Test
	public void testTrim04() {
		String result = target.trim(RecordFieldConstants.ALGIN_RIGHT, "0", "0001020");
		Assert.assertEquals("1020", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * g邱ƂmFB
	 *   pfBOF"0"AACgF"right"Af[^F"0123 "
	 */
	@Test
	public void testTrim05() {
		String result = target.trim(RecordFieldConstants.ALGIN_LEFT, "0", "01203000");
		Assert.assertEquals("01203", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * pfBOw̏ꍇAgȂƂmFB
	 */
	@Test
	public void testTrim06() {
		// pfBOF null
		String result = target.trim(RecordFieldConstants.ALGIN_LEFT, null, "0123 ");
		Assert.assertEquals("0123 ", result);

		// pfBOF""
		result = target.trim(RecordFieldConstants.ALGIN_LEFT, "", "0123 ");
		Assert.assertEquals("0123 ", result);
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * ACguleftvƁurightvȊȌꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testTrimDataFormatException01() {
		target.trim("middle", "0", "0012300");
	}

	/**
	 * {@link RecordFieldReaderFormat#trim(String, String, String)} ̂߂̃eXgE\bhB<br>
	 * pfBÕoCg1oCgȏ̏ꍇAႪ邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testTrimDataFormatException02() {
		target.trim(RecordFieldConstants.ALGIN_LEFT, "00", "00001230000");
	}

}
