/*
 * RecordFieldWriterFormatTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess;


import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormat;
import jp.co.cybec.cb3.exception.DataFormatException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link RecordFieldWriterFormat} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class RecordFieldWriterFormatTest {
	RecordFieldWriterFormat target = null;

	@Before
	public void setUp() throws Exception {
		target = new RecordFieldWriterFormat("delimitedLineRecordWriteConfig1.xml", "name");
	}

	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * tH[}bg邱ƂmFB
	 *   f[^^FAp^[F"#,###.00"
	 */
	@Test
	public void testFormat01() {
		String result = target.format("#,###.00", RecordFieldConstants.TYPE_NUMBER, "123456.2");
		Assert.assertEquals("123,456.20", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * p^[w̏ꍇAtH[}bgȂƂmFB
	 */
	@Test
	public void testFormat02() {
		// p^[Fnull
		String result = target.format(null, RecordFieldConstants.TYPE_NUMBER, "010.202");
		Assert.assertEquals("010.202", result);

		// p^[F""
		result = target.format("", RecordFieldConstants.TYPE_NUMBER, "010.202");
		Assert.assertEquals("010.202", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * tH[}bg邱ƂmFB
	 *   f[^^FAp^[F"#.000"A^CvF".25"
	 */
	@Test
	public void testFormat03() {
		String result = target.format("#.000", RecordFieldConstants.TYPE_NUMBER, ".102");
		Assert.assertEquals(".102", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * tH[}bg邱ƂmFB
	 *   f[^^FtAp^[F"yyyyMMdd"Af[^F"2008/01/02 00:00:00"
	 */
	@Test
	public void testFormat04() {
		String result = target.format("yyyyMMdd", RecordFieldConstants.TYPE_DATE, "2008/01/02 00:00:00");
		Assert.assertEquals("20080102", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * tH[}bg邱ƂmFB
	 *   f[^^FtAp^[F"yyyy-MM-dd"Af[^F"2008/01/02 00:00:00"
	 */
	@Test
	public void testFormat05() {
		String result = target.format("yyyy-MM-dd", RecordFieldConstants.TYPE_DATE, "2008/01/02 00:00:00");
		Assert.assertEquals("2008-01-02", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * tH[}bg邱ƂmFB
	 *   f[^^FtAp^[F"MM-dd-yy HH:mm:ss"Af[^F"2008/01/02 13:20:33"
	 */
	@Test
	public void testFormat06() {
		String result = target.format("MM-dd-yy HH:mm:ss", RecordFieldConstants.TYPE_DATE, "2008/01/02 13:20:33");
		Assert.assertEquals("01-02-08 13:20:33", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * f[^nullL̏ꍇANULLԂƂmFB
	 *   f[^^FtAp^[F"yyyyMMdd"Af[^Fnull
	 */
	@Test
	public void testFormat07() {
		String result = target.format("yyyyMMdd", RecordFieldConstants.TYPE_DATE, null);
		Assert.assertNull(result);
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * ^CvwꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException01() {
		target.format("#.00", null, "1212.200");
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * ^CvunumbervƁudatevȊȌꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException02() {
		target.format("#.00", "integer", "1212.200");
	}

	/**
	 * {@link RecordFieldWriterFormat#format(String, String, String)} ̂߂̃eXgE\bhB
	 * f[^̃tH[}bgp^[ƈقȂꍇAO邱ƂmFB
	 *   f[^^FtAp^[F"yyyyMMdd"Af[^F"2008/01/02"
	 */
	@Test(expected = DataFormatException.class)
	public void testFormatDataFormatException03() {
		target.format("yyyyMMdd", RecordFieldConstants.TYPE_DATE, "2008/01/02");
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * pfBO邱ƂmFB
	 *  f[^̒F"7"AACgwqF"left"ApfBOF" "
	 */
	@Test
	public void testPadding01() {
		String result = target.padding("7", RecordFieldConstants.ALGIN_LEFT, " ", "ab12");
		Assert.assertEquals("ab12   ", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * pfBO邱ƂmFB
	 *   f[^̒F"7"AACgwqF"right"ApfBOF" "
	 */
	@Test
	public void testPadding02() {
		String result = target.padding("7", RecordFieldConstants.ALGIN_RIGHT, " ", "ab12");
		Assert.assertEquals("   ab12", result);
	}


	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * f[^nullƋ󔒂̏ꍇApfBO邱ƂmFB
	 */
	@Test
	public void testPadding03() {
		// f[^Fnull
		String result = target.padding("5", RecordFieldConstants.ALGIN_LEFT, " ", null);
		Assert.assertEquals("     ", result);

		// f[^F ""
		result = target.padding("5", RecordFieldConstants.ALGIN_LEFT, " ", "");
		Assert.assertEquals("     ", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * oCgw̏ꍇApfBOȂƂmFB
	 */
	@Test
	public void testPadding04() {
		// oCgFnull
		String result = target.padding(null, RecordFieldConstants.ALGIN_LEFT, " ", "testf[^");
		Assert.assertEquals("testf[^", result);

		// oCgF""
		result = target.padding("", RecordFieldConstants.ALGIN_LEFT, " ", "testf[^");
		Assert.assertEquals("testf[^", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * pfBOw̏ꍇApfBOȂƂmFB
	 */
	@Test
	public void testPadding05() {
		// pfBOFnull
		String result = target.padding("20", RecordFieldConstants.ALGIN_LEFT, null, "testf[^");
		Assert.assertEquals("testf[^", result);

		// pfBOF""
		result = target.padding("20", RecordFieldConstants.ALGIN_LEFT, "", "testf[^");
		Assert.assertEquals("testf[^", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * ACgw̏ꍇApfBOȂƂmFB
	 */
	@Test
	public void testPadding06() {
		// ACgFnull
		String result = target.padding("20", null, " ", "testf[^");
		Assert.assertEquals("testf[^", result);

		// ACgF""
		result = target.padding("20", "", " ", "testf[^");
		Assert.assertEquals("testf[^", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * pfBO邱ƂmFB
	 *  f[^̒F"10"AACgwqF"left"ApfBOF" "
	 */
	@Test
	public void testPadding07() {
		String result = target.padding("10", RecordFieldConstants.ALGIN_LEFT, " ", "ab12");
		Assert.assertEquals("ab12  ", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * pfBO邱ƂmFB
	 *  f[^̒F"10"AACgwqF"right"ApfBOF" "
	 */
	@Test
	public void testPadding08() {
		String result = target.padding("10", RecordFieldConstants.ALGIN_RIGHT, " ", "12");
		Assert.assertEquals("    12", result);
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * f[^̃oCgwoCg傫ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testPaddingDataFormatException01() {
		target.padding("5", RecordFieldConstants.ALGIN_RIGHT, " ", "f[^ab");
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * oCgȂꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testPaddingDataFormatException02() {
		target.padding("asda", RecordFieldConstants.ALGIN_RIGHT, " ", "f[^Test");
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * pfBÕoCg1oCgȏ̏ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testPaddingDataFormatException03() {
		target.padding("16", RecordFieldConstants.ALGIN_RIGHT, "  ", "errtest");
	}

	/**
	 * {@link RecordFieldWriterFormat#padding(String, String, String, String)} ̂߂̃eXgE\bhB
	 * ACgwquleftvƁurightvȊȌꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testPaddingDataFormatException04() {
		target.padding("9", "center", "*", "test");
	}
}
