/*
 * FlatFileRecordImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.LinkedHashMap;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.exception.DataFormatException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FlatFileRecordImpl} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class FlatFileRecordImplTest {

	// ϐ
	private FlatFileRecord record1 = null;
	private FlatFileRecord record2 = null;

	private LinkedHashMap<String, String> fileRecordMap1 = null;
	private LinkedHashMap<String, String> fileRecordMap2 = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		// eXgf[^P
		fileRecordMap1 = new LinkedHashMap<String, String>();
		fileRecordMap1.put("intField", "12345");
		fileRecordMap1.put("strField", "teststringeXgf[^");
		fileRecordMap1.put("longField", "1456785");
		fileRecordMap1.put("shortField", "123");
		fileRecordMap1.put("floatField", "1123.461");
		fileRecordMap1.put("doubleField", "7008123.4610");
		fileRecordMap1.put("bigField", "9802361123456.012");
		fileRecordMap1.put("dateField", "2008/01/02 00:00:00");
		fileRecordMap1.put("emptyField", "");
		record1 = new FlatFileRecordImpl(fileRecordMap1);

		// eXgf[^Q
		fileRecordMap2 = new LinkedHashMap<String, String>();
		fileRecordMap2.put("intField", "999999999999999");
		fileRecordMap2.put("longField", "999999999999999999999");
		fileRecordMap2.put("shortField", "999999999999999");
		fileRecordMap2.put("floatField", "ssss");
		fileRecordMap2.put("doubleField", "ssss");
		fileRecordMap2.put("bigField", "#999999999999999");
		fileRecordMap2.put("dateField", "9990099");
		record2 = new FlatFileRecordImpl(fileRecordMap2);

	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {

	}

	/**
	 * {@link FlatFileRecordImpl} ̂߂̃eXgE\bhB
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetAll() throws ParseException{

		// getInteger
		Assert.assertEquals(new Integer("12345"), record1.getInteger("intField"));
		// getString
		Assert.assertEquals("teststringeXgf[^", record1.getString("strField"));
		// getLong
		Assert.assertEquals(new Long("1456785"), record1.getLong("longField"));
		// getShort
		Assert.assertEquals(new Short("123"), record1.getShort("shortField"));
		// getFloat
		Assert.assertEquals(new Float("1123.461"), record1.getFloat("floatField"));
		// getDouble
		Assert.assertEquals(new Double("7008123.4610"), record1.getDouble("doubleField"));
		// getBigDecimal
		Assert.assertEquals(new BigDecimal("9802361123456.012"), record1.getBigDecimal("bigField"));
		// getDate
		Assert.assertEquals(DateFormat.getDateInstance().parse("2008/01/02 00:00:00"), record1.getDate("dateField"));
		//toMap
		Assert.assertEquals(fileRecordMap1, record1.toMap());
	}

	/**
	 * {@link FlatFileRecordImpl} ̂߂̃eXgE\bhB
	 * ɑ݂ȂL[itB[hjw肵nullԂƂmFB
	 */
	@Test
	public void testGetNull() {
		// getBigDecimal
		Assert.assertNull(record1.getBigDecimal("nokey"));
		// getDate
		Assert.assertNull(record1.getDate("nokey"));
		// getDouble
		Assert.assertNull(record1.getDouble("nokey"));
		// getFloat
		Assert.assertNull(record1.getFloat("nokey"));
		// getInteger
		Assert.assertNull(record1.getInteger("nokey"));
		// getLong
		Assert.assertNull(record1.getLong("nokey"));
		// getShort
		Assert.assertNull(record1.getShort("nokey"));
		// getString
		Assert.assertNull(record1.getString("nokey"));
	}

	/**
	 * {@link FlatFileRecordImpl} ̂߂̃eXgE\bhB
	 * ͋w肵nullԂƂmFB
	 * f[^F""
	 */
	@Test
	public void testGetEmpty() {
		// getBigDecimal
		Assert.assertNull(record1.getBigDecimal("emptyField"));
		// getDate
		Assert.assertNull(record1.getDate("emptyField"));
		// getDouble
		Assert.assertNull(record1.getDouble("emptyField"));
		// getFloat
		Assert.assertNull(record1.getFloat("emptyField"));
		// getInteger
		Assert.assertNull(record1.getInteger("emptyField"));
		// getLong
		Assert.assertNull(record1.getLong("emptyField"));
		// getShort
		Assert.assertNull(record1.getShort("emptyField"));
	}

	/**
	 * {@link FlatFileRecordImpl#getBigDecimal(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"#999999999999999"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetBigDecimalDataFormatException() {
		record2.getBigDecimal("bigField");
	}

	/**
	 * {@link FlatFileRecordImpl#getInteger(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"999999999999999"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetIntegerDataFileIOException() {
		record2.getInteger("intField");
	}

	/**
	 * {@link FlatFileRecordImpl#getLong(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"999999999999999999999"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetLongDataFileIOException() {
		record2.getLong("longField");
	}

	/**
	 * {@link FlatFileRecordImpl#getShort(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"999999999999999"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetShortDataFileIOException() {
		record2.getShort("shortField");
	}

	/**
	 * {@link FlatFileRecordImpl#getDate(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"9990099"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetDateDataFileIOException() {
		record2.getDate("dateField");
	}

	/**
	 * {@link FlatFileRecordImpl#getFloat(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"ssss"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetFloatDataFileIOException() {
		record2.getFloat("floatField");
	}

	/**
	 * {@link FlatFileRecordImpl#getDouble(String)} ̂߂̃eXgE\bhB
	 * l̕ϊsƂɗO邱ƂmFB
	 *   f[^F"ssss"
	 */
	@Test(expected = DataFormatException.class)
	public void testGetDoubleDataFileIOException() {
		record2.getDouble("doubleField");
	}

	/**
	 * {@link FlatFileRecordImpl#toMap()} ̂߂̃eXgE\bhB
	 * 1R[hMapeXg
	 */
	@Test
	public void testToMapSize() {
		// ʃ`FbN
		Assert.assertEquals(9, record1.toMap().size());
	}

}
