/*
 * FlatFileRecordWriterImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriterImpl;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FlatFileRecordWriterImpl} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class FlatFileRecordWriterImplTest {

	/** ݗp f[^t@C */
	private static final String CVS_FILE_NORMAL= "src/test/testdata/delimited/testWriter01.csv";

	private FlatFileRecordWriterImpl target = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		target = new FlatFileRecordWriterImpl();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
		target.release();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#open()} ̂߂̃eXgE\bhB
	 * ǉ[hŃt@CI[v鎞ɗOȂƂmFB
	 */
	@Test
	public void testOpenAppendTrue() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("true");
		target.setEncode("Shift_JIS");

	 	target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#open()} ̂߂̃eXgE\bhB
	 * ㏑[hŃt@CI[v鎞ɗOȂƂmFB
	 */
	@Test
	public void testOpenAppendFalse() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("false");
		target.setEncode("Shift_JIS");

	 	target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#open()} ̂߂̃eXgE\bhB
	 * t@CpX݂ȂɁAO邱ƂmFB
	 */
	@Test(expected = DataFileNotFoundException.class)
	public void testOpenDataFileNotFoundException() {
		target.setFilepath("H:\test.txt");
		target.setAppend("true");
		target.setEncode("Shift_JIS");

		target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#open()} ̂߂̃eXgE\bhB
	 * QI[vƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorAlreadyOpenedException.class)
	public void testOpenAccessorAlreadyOpenedException() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("false");
		target.setEncode("Shift_JIS");

		target.open();
		target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#open()} ̂߂̃eXgE\bhB
	 * f[^t@Cnull̎ɗO邱ƂmFB
	 */
	@Test(expected = DataFileNotFoundException.class)
	public void testOpenNullFilepath() {
		target.setFilepath(null);
		target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#open()} ̂߂̃eXgE\bhB
	 * f[^t@C̓ǂݍ݂ɎsɗO邱ƂmFB
	 */
	@Test(expected = DataFileIOException.class)
	public void testOpenDataFileIOException() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("true");
		target.setEncode("EUC");

		target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#close()} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testClose() {
	 	target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("true");
		target.setEncode("Shift_JIS");

	 	target.open();
	 	target.close();
	 	target.open();
	}


	/**
	 * {@link FlatFileRecordWriterImpl#close()} ̂߂̃eXgE\bhB
	 * t@CI[vĂȂĂAOȂƂmFB
	 */
	@Test
	public void testCloseNoOpen() {
	 	target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("false");
		target.setEncode("Shift_JIS");

	 	target.close();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#release()} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testRelease() {
	 	target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("true");
		target.setEncode("Shift_JIS");

	 	target.open();
	 	target.release();
	 	target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#isOpen()} ̂߂̃eXgE\bhB
	 * t@CI[vt@C̃I[vԂێtOݒł邱ƂmF邱ƁB
	 */
	@Test
	public void testIsOpenOpen() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.setAppend("true");
		target.open();
		Assert.assertEquals(true, target.isOpen());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#isOpen()} ̂߂̃eXgE\bhB
	 * t@CN[Yt@C̃I[vԂێtOݒł邱ƂmF邱ƁB
	 */
	@Test
	public void testIsOpenClose() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setEncode("Shift_JIS");
		target.setAppend("true");
		target.open();
		target.close();
		Assert.assertEquals(false, target.isOpen());
		target.open();
	}

	/**
	 * {@link FlatFileRecordWriterImpl#getBufferedWriter()} ̂߂̃eXgE\bhB
	 * obt@[C^[擾ł邱ƂmFB
	 */
	@Test
	public void testGetBufferedWriter() {
		target.setFilepath(CVS_FILE_NORMAL);
		target.setAppend("false");
		target.setEncode("Shift_JIS");
		target.open();
		Assert.assertNotNull(target.getBufferedWriter());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#getAppend()} ̂߂̃eXgE\bhB
	 * t@CI[v[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetAppend() {
		target.setAppend("true");
		Assert.assertEquals(true, target.getAppend());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#setAppend(String)} ̂߂̃eXgE\bhB
	 * t@CI[v[hݒł邱ƂmFB
	 */
	@Test
	public void testSetAppend() {
		target.setAppend("false");
		Assert.assertEquals(false, target.getAppend());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#getEncode()} ̂߂̃eXgE\bhB
	 * GR[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetEncode() {
		target.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS", target.getEncode());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#setEncode(String)} ̂߂̃eXgE\bhB
	 * GR[hݒł邱ƂmFB
	 */
	@Test
	public void testSetEncode() {
		target.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS", target.getEncode());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#getFilepath()} ̂߂̃eXgE\bhB
	 * t@CpX擾ł邱ƂmFB
	 */
	@Test
	public void testGetFilepath() {
		target.setFilepath("D:/test.csv");
		Assert.assertEquals("D:/test.csv", target.getFilepath());
	}

	/**
	 * {@link FlatFileRecordWriterImpl#setFilepath(String)} ̂߂̃eXgE\bhB
	 * t@CpXݒł邱ƂmFB
	 */
	@Test
	public void testSetFilepath() {
		target.setFilepath("D:/test.csv");
		Assert.assertEquals("D:/test.csv", target.getFilepath());
	}
}
