/*
 * DelimitedLineRecordFieldConfigTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordFieldConfig;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link DelimitedLineRecordFieldConfig} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class DelimitedLineRecordFieldConfigTest {

	DelimitedLineRecordFieldConfig target = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		target = new DelimitedLineRecordFieldConfig();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getName()} ̂߂̃eXgE\bhB
	 * tB[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetName() {
		target.setName("id");
		Assert.assertEquals("id", target.getName());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setName(String)} ̂߂̃eXgE\bhB
	 * tB[hݒł邱ƂmFB
	 */
	@Test
	public void testSetName() {
		target.setName("id01");
		Assert.assertEquals("id01", target.getName());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getPattern()} ̂߂̃eXgE\bhB
	 * p^[擾ł邱ƂmFB
	 */
	@Test
	public void testGetPattern() {
		target.setPattern("#.##");
		Assert.assertEquals("#.##", target.getPattern());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setPattern(String)} ̂߂̃eXgE\bhB
	 * p^[ݒł邱ƂmFB
	 */
	@Test
	public void testSetPattern() {
		target.setPattern("#.##");
		Assert.assertEquals("#.##", target.getPattern());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getPatternClass()} ̂߂̃eXgE\bhB
	 * p^[NX擾ł邱ƂmFB
	 */
	@Test
	public void testGetPatternClass() {
		target.setPatternClass("jp.co.cybec.cb3.abc");
		Assert.assertEquals("jp.co.cybec.cb3.abc", target.getPatternClass());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setPatternClass(String)} ̂߂̃eXgE\bhB
	 * p^[NXݒł邱ƂmFB
	 */
	@Test
	public void testSetPatternClass() {
		target.setPatternClass("jp.co.cybec.cb3.abc");
		Assert.assertEquals("jp.co.cybec.cb3.abc", target.getPatternClass());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getPatternClass()} ̂߂̃eXgE\bhB
	 * tB[hl̃oCg擾ł邱ƂmFB
	 */
	@Test
	public void testGetLength() {
		target.setLength("10");
		Assert.assertEquals("10", target.getLength());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setPatternClass(String)} ̂߂̃eXgE\bhB
	 * tB[hl̃oCgݒł邱ƂmFB
	 */
	@Test
	public void testSetLength() {
		target.setLength("10");
		Assert.assertEquals("10", target.getLength());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getAlign()} ̂߂̃eXgE\bhB
	 * ACgwq擾ł邱ƂmFB
	 */
	@Test
	public void testGetAlign() {
		target.setAlign("left");
		Assert.assertEquals("left", target.getAlign());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setAlign(String)} ̂߂̃eXgE\bhB
	 * ACgwqݒ肷邱ƂmFB
	 */
	@Test
	public void testSetAlign() {
		target.setAlign("left");
		Assert.assertEquals("left", target.getAlign());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getPadding()} ̂߂̃eXgE\bhB
	 * pfBO擾ł邱ƂmFB
	 */
	@Test
	public void testGetPadding() {
		target.setPadding(" ");
		Assert.assertEquals(" ", target.getPadding());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setPadding(String)} ̂߂̃eXgE\bhB
	 * pfBOݒł邱ƂmFB
	 */
	@Test
	public void testSetPadding() {
		target.setPadding(" ");
		Assert.assertEquals(" ", target.getPadding());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#getType()} ̂߂̃eXgE\bhB
	 * p^[^Cv擾ł邱ƂmFB
	 */
	@Test
	public void testGetType() {
		target.setType("number");
		Assert.assertEquals("number", target.getType());
	}

	/**
	 * {@link DelimitedLineRecordFieldConfig#setType(String)} ̂߂̃eXgE\bhB
	 * p^[^Cvݒł邱ƂmFB
	 */
	@Test
	public void testSetType() {
		target.setType("number");
		Assert.assertEquals("number", target.getType());
	}
}
