/*
 * DelimitedLineRecordWriterTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordWriter;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link DelimitedLineRecordWriter} ̃eXgP[XB
 * @author Juanjuan Wang
 */
public class DelimitedLineRecordWriterTest {

	private DelimitedLineRecordWriter delimitedWriter = null;
	private FlatFileRecord record = null;

	/** appendF"true"AseparatorF","AquotecharF"&quot;"AlineSeparatorF"\r\n"AencodeF"Shift_JIS"̏ꍇAݗp t@C */
	private static final String CONFIG_WRITE1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig1.xml";

	/** appendF"false"AseparatorF""AquotecharF""AlineSeparatorF""AencodeF""̏ꍇAݗp t@C  */
	private static final String CONFIG_WRITE2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig2.xml";

	/** ϒ̃C^[̃~j}Zbg̏ꍇAݗp t@C */
	private static final String CONFIG_WRITE3 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig3.xml";

	/** p^[NXݒ肳ꂽꍇAݗp t@C */
	private static final String CONFIG_WRITE4 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig6.xml";

	/** [U[`NX݂Ȃ */
	private static final String CONFIG_WRITE5 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig7.xml";

	/** t@CI[vĂȂ */
	private static final String CONFIG_WRITE6 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig3.xml";

	/** p^[NX̏ꍇAtH[}bg鎞ɁAO */
	private static final String CONFIG_WRITE7 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig8.xml";

	/** FlatFileRecordf[^쐬p t@C */
	private static final String CONFIG_CREATE_RECORD1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig4.xml";

	/** FlatFileRecordf[^NULL */
	private static final String CONFIG_CREATE_RECORD2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/delimited/writer/writeConfig5.xml";

	/** f[^t@C */
	private static final String FILE_NORMAL= "src/test/testdata/delimited/test_write.csv";

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		delimitedWriter = new DelimitedLineRecordWriter();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
		delimitedWriter.release();
	}

	/**
	 * {@link DelimitedLineRecordWriter#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testInitialize() {
		delimitedWriter.initialize(CONFIG_WRITE1);
	}

	/**
	 * {@link DelimitedLineRecordWriter#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * ɑ݂ȂL[iݒt@Cjw肵ƂɗO邱ƂmFB
	 */
	@Test(expected = ConfigFileNotFoundException.class)
	public void testInitializeConfigFileNotFoundException() {
		delimitedWriter.initialize("aaa");
	}

	/**
	 * {@link DelimitedLineRecordWriter#open(String)} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testOpenString() {
		delimitedWriter.initialize(CONFIG_WRITE1);
		delimitedWriter.open(FILE_NORMAL);
	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * R[ht@Cɏ݂ł邱ƂmFB
	 * appendF "true"
	 * separatorF","
	 * quotecharF "&quot;"
	 * encode   F "Shift_JIS"
	 * lineSeparatorF"\r\n"
	 */
	@Test
	public void testWrite01() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE1);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
		delimitedWriter.write(record);
		delimitedWriter.write(record);
	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * R[ht@Cɏ݂ł邱ƂmFB
	 * appendF "false"
	 * separatorFȂ
	 * quotecharFȂ
	 * encode   FȂ
	 * lineSeparatorFȂ
	 */
	@Test
	public void testWrite02() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE2);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
		delimitedWriter.write(record);

	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * ϒ̃C^[̃~j}Zbg̏ꍇAR[ht@Cɏ݂ł邱ƂmFB
	 */
	@Test
	public void testWrite03() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE3);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
		delimitedWriter.write(record);
		delimitedWriter.write(record);

	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * p^[NXݒ肳ꂽꍇAR[ht@Cɏ݂ł邱ƂmFB
	 */
	@Test
	public void testWrite04() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE4);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
		delimitedWriter.write(record);
		delimitedWriter.write(record);
	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * p^[NXݒ肳ꂽꍇA[U[`NX݂ȂŗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testWrite05() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE5);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);

	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * t@CI[vĂȂꍇAO邱ƂmFB
	 */
	@Test(expected = AccessorNotOpenException.class)
	public void testWrite06() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE6);
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
	}

	/**
	 * {@link DelimitedLineRecordWriter#write(FlatFileRecord)} ̂߂̃eXgE\bhB
	 * p^[NXݒ肳ꂽꍇAtH[}bg鎞ɁAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testWrite07() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "#1");
		fileRecordMap.put("strField1", "tests\"tring1");
		fileRecordMap.put("strField2", "testϐ̂PQR");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");
		fileRecordMap.put("dateField2", "2002/02/23 00:00:00");
		fileRecordMap.put("dateField3", "2001/05/23 07:12:23");
		fileRecordMap.put("longField", "123456789120325");
		fileRecordMap.put("shortField", "1045852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("bigField", "18975125355445852642");
		fileRecordMap.put("doubleField", "18975125355445852642.1022");
		fileRecordMap.put("floatField", "5125355445852642.2");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_WRITE7);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
	}

	/**
	 * {@link DelimitedLineRecordWriter#createFlatFileRecord(Map)} ̂߂̃eXgE\bhB
	 * FlatFileRecordf[^쐬邱ƂmFB
	 */
	@Test
	public void testCreateFlatFileRecord01() {
		// \zf[^
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		fileRecordMap.put("intField", "1");
		fileRecordMap.put("strField1", "teststring1");
		fileRecordMap.put("strField2", "teststring2");
		fileRecordMap.put("dateField1", "2001/05/23 07:12:23");

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_CREATE_RECORD1);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);

		// ʂ`FbN
		Assert.assertEquals("1", record.toMap().get("intField").toString());
		Assert.assertEquals("teststring1", record.toMap().get("strField1").toString());
		Assert.assertEquals("teststring2", record.toMap().get("strField2").toString());
		Assert.assertEquals("2001/05/23 07:12:23", record.toMap().get("dateField1").toString());
	}

	/**
	 * {@link DelimitedLineRecordWriter#createFlatFileRecord(Map)} ̂߂̃eXgE\bhB
	 * FlatFileRecordf[^NULLmFB
	 */
	@Test
	public void testCreateFlatFileRecord02() {
		LinkedHashMap<String, String> fileRecordMap = null;

		// ݒt@Cǂݍ
		delimitedWriter.initialize(CONFIG_CREATE_RECORD2);
		delimitedWriter.open();
		record = delimitedWriter.createFlatFileRecord(fileRecordMap);
		delimitedWriter.write(record);
	}

}
