/*
 * FixedLengthRecordReaderConfigTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordReaderConfig;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FixedLengthRecordReaderConfig} ̃eXgP[XB
 * @author Sufang Gou
 */

public class FixedLengthRecordReaderConfigTest {
	FixedLengthRecordReaderConfig readerConfig = null;
	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		readerConfig = new FixedLengthRecordReaderConfig();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link FixedLengthRecordReaderConfig#getFilepath()} ̂߂̃eXgE\bhB
	 * t@CpX擾ł邱ƂmFB
	 */
	@Test
	public void testGetFilepath() {
		readerConfig.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv",readerConfig.getFilepath());
	}

	/**
	 * {@link FixedLengthRecordReaderConfig#setFilepath(String)} ̂߂̃eXgE\bhB
	 * t@CpXݒł邱ƂmFB
	 */
	@Test
	public void testSetFilepath() {
		readerConfig.setFilepath("c:\test.csv");
		Assert.assertEquals("c:\test.csv",readerConfig.getFilepath());
	}

	/**
	 * {@link FixedLengthRecordReaderConfig#getFieldList()} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xg擾ł邱ƂmFB
	 */
	@Test
	public void testGetFieldList() {
		FixedLengthRecordFieldConfig field = new FixedLengthRecordFieldConfig();
		field.setAlign("left");
		readerConfig.addField(field);
		field.setName("name");
		readerConfig.addField(field);
		field.setPadding(" ");
		readerConfig.addField(field);
		field.setPattern("0");
		readerConfig.addField(field);
		field.setPatternClass("pattern_class");
		readerConfig.addField(field);
		field.setLength("10");
		readerConfig.addField(field);
		field.setType("type");
		readerConfig.addField(field);
		Assert.assertEquals(7, readerConfig.getFieldList().size());
		Assert.assertEquals("left", readerConfig.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", readerConfig.getFieldList().get(1).getName());
		Assert.assertEquals(" ", readerConfig.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", readerConfig.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", readerConfig.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", readerConfig.getFieldList().get(5).getLength());
		Assert.assertEquals("type", readerConfig.getFieldList().get(6).getType());
	}

	/**
	 * {@link FixedLengthRecordReaderConfig#addField(FixedLengthRecordFieldConfig)} ̂߂̃eXgE\bhB
	 * tB[h񃊃Xgݒł邱ƂmFB
	 */
	@Test
	public void testAddField() {
		FixedLengthRecordFieldConfig field = new FixedLengthRecordFieldConfig();
		field.setAlign("left");
		readerConfig.addField(field);
		field.setName("name");
		readerConfig.addField(field);
		field.setPadding(" ");
		readerConfig.addField(field);
		field.setPattern("0");
		readerConfig.addField(field);
		field.setPatternClass("pattern_class");
		readerConfig.addField(field);
		field.setLength("10");
		readerConfig.addField(field);
		field.setType("type");
		readerConfig.addField(field);
		Assert.assertEquals(7, readerConfig.getFieldList().size());
		Assert.assertEquals("left", readerConfig.getFieldList().get(0).getAlign());
		Assert.assertEquals("name", readerConfig.getFieldList().get(1).getName());
		Assert.assertEquals(" ", readerConfig.getFieldList().get(2).getPadding());
		Assert.assertEquals("0", readerConfig.getFieldList().get(3).getPattern());
		Assert.assertEquals("pattern_class", readerConfig.getFieldList().get(4).getPatternClass());
		Assert.assertEquals("10", readerConfig.getFieldList().get(5).getLength());
		Assert.assertEquals("type", readerConfig.getFieldList().get(6).getType());
	}
	/**
	 * {@link FixedLengthRecordReaderConfig#getEncode()} ̂߂̃eXgE\bhB
	 * R[h擾ł邱ƂmFB
	 */
	@Test
	public void testGetEncode() {
		readerConfig.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS",readerConfig.getEncode());
	}
	/**
	 * {@link FixedLengthRecordReaderConfig#setEncode(String)} ̂߂̃eXgE\bhB
	 * R[h擾ł邱ƂmFB
	 */
	@Test
	public void testSetEncode() {
		readerConfig.setEncode("Shift_JIS");
		Assert.assertEquals("Shift_JIS",readerConfig.getEncode());
	}
}
