/*
 * FixedLengthRecordReaderTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordReader;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link FixedLengthRecordReader} ̃eXgP[XB
 * @author Sufang Gou
 */

public class FixedLengthRecordReaderTest {
	// NXCX^X
	FixedLengthRecordReader target = null;
	private FlatFileRecord record;

	/** ǂݍݗp t@C */
	private static final String CONFIG_READER1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig1.xml";
	private static final String CONFIG_READER2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig2.xml";

	/** ǂݍݗp f[^t@C̋LqȂ */
	private static final String CONFIG_READER_PARSE_ERROR1 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig3.xml";
	private static final String CONFIG_READER_PARSE_ERROR2 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig4.xml";
	private static final String CONFIG_READER_PARSE_ERROR3 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig5.xml";
	private static final String CONFIG_READER_PARSE_ERROR4 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig6.xml";
	private static final String CONFIG_READER_PARSE_ERROR5 = "jp/co/cybec/cb3/accessor/fileaccess/flat/fixed/reader/readerConfig7.xml";

	/** f[^t@C */
	private static final String FILE_NORMAL= "src/test/testdata/fixed/test1.txt";

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		// NXCX^X
		target = new FixedLengthRecordReader();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
		target.release();
	}

	/**
	 * {@link FixedLengthRecordReader#open(String)} ̂߂̃eXgE\bhB
	 * OȂƂmFB
	 */
	@Test
	public void testOpenString() {
		target.initialize(CONFIG_READER1);
		target.open(FILE_NORMAL);
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * OȂƂmF
	 * encode Shift_JIS
	 */
	@Test
	public void testNextRecord01() {
		// ݒt@CǂݍށB
		target.initialize(CONFIG_READER1);

		//t@CI[vB
		target.open();

		// f[^擾B
		record = target.nextRecord();

		// ʂ`FbN
		Assert.assertEquals("1111111111", record.getString("intField"));
		Assert.assertEquals("2222222222", record.getString("strField1"));
		Assert.assertEquals("| @\"T̐ToPQRp", record.getString("strField2"));
		Assert.assertEquals("1234", record.getString("longField"));
		Assert.assertEquals("1234", record.getString("shortField"));
		Assert.assertEquals("1111.461", record.getString("floatField"));
		Assert.assertEquals("111111.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.011", record.getString("bigField2"));
		Assert.assertEquals("2007/05/28 00:00:00", record.getString("dateField1"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField3"));
		Assert.assertEquals("10%", record.getString("strField4"));
		Assert.assertEquals("2001/11/05 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("2001/10/05 08:01:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 00:00:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 10:10:01", record.getString("dateField5"));

		record = null;
		// f[^擾B
		record = target.nextRecord();

		// ʂ`FbNB
		Assert.assertEquals("3333333333", record.getString("intField"));
		Assert.assertEquals("4444444444", record.getString("strField1"));
		Assert.assertEquals("| @\"T̐ToPQRp", record.getString("strField2"));
		Assert.assertEquals("5678", record.getString("longField"));
		Assert.assertEquals("5678", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/08/08 00:00:00", record.getString("dateField1"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField3"));
		Assert.assertEquals("10%", record.getString("strField4"));
		Assert.assertEquals("2001/11/05 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("2001/10/05 08:01:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 00:00:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 10:10:01", record.getString("dateField5"));

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * OȂƂmF
	 * encode null
	 *
	 */
	@Test
	public void testNextRecord02() {
		// ݒt@CǂݍށB
		target.initialize(CONFIG_READER2);

		//t@CI[vB
		target.open();
		// f[^擾
		record = target.nextRecord();

		// ʂ`FbNB
		Assert.assertEquals("1111111111", record.getString("intField"));
		Assert.assertEquals("2222222222", record.getString("strField1"));
		Assert.assertEquals("| @\"T̐ToPQRp", record.getString("strField2"));
		Assert.assertEquals("1234", record.getString("longField"));
		Assert.assertEquals("1234", record.getString("shortField"));
		Assert.assertEquals("1111.461", record.getString("floatField"));
		Assert.assertEquals("111111.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.011", record.getString("bigField2"));
		Assert.assertEquals("2007/05/28 00:00:00", record.getString("dateField1"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField3"));
		Assert.assertEquals("10%", record.getString("strField4"));
		Assert.assertEquals("2001/11/05 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("2001/10/05 08:01:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 00:00:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 10:10:01", record.getString("dateField5"));

		record = null;
		// f[^擾B
		record = target.nextRecord();

		// ʂ`FbNB
		Assert.assertEquals("3333333333", record.getString("intField"));
		Assert.assertEquals("4444444444", record.getString("strField1"));
		Assert.assertEquals("| @\"T̐ToPQRp", record.getString("strField2"));
		Assert.assertEquals("5678", record.getString("longField"));
		Assert.assertEquals("5678", record.getString("shortField"));
		Assert.assertEquals("1123.461", record.getString("floatField"));
		Assert.assertEquals("123456.012", record.getString("bigField1"));
		Assert.assertEquals("1234565648.012", record.getString("bigField2"));
		Assert.assertEquals("2008/08/08 00:00:00", record.getString("dateField1"));
		Assert.assertEquals("{c2www.bb@hotmail.com.cn", record.getString("strField3"));
		Assert.assertEquals("10%", record.getString("strField4"));
		Assert.assertEquals("2001/11/05 00:00:00", record.getString("dateField2"));
		Assert.assertEquals("2001/10/05 08:01:00", record.getString("dateField3"));
		Assert.assertEquals("2001/09/29 00:00:00", record.getString("dateField4"));
		Assert.assertEquals("2001/09/10 10:10:01", record.getString("dateField5"));

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * t@CI[vȂƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorNotOpenException.class)
	public void testNextRecord03() {
		// ݒt@CǂݍށB
		target.initialize(CONFIG_READER2);

		// f[^擾
		target.nextRecord();

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * sȏꍇ̃eXg
	 * Psf[^̃oCg <> ݒt@C̃oCgv̂ƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord04() {
		// ݒt@CǂݍށB
		target.initialize(CONFIG_READER_PARSE_ERROR1);

		//t@CI[vB
		target.open();

		// f[^擾B
		target.nextRecord();

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * sȏꍇ̃eXg
	 * [U[`NX̃CX^XsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord05() {
		// ݒt@Cǂݍ
		target.initialize(CONFIG_READER_PARSE_ERROR2);

		//t@CI[vB
		target.open();

		// f[^擾B
		record = target.nextRecord();

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * sȏꍇ̃eXg
	 * oCgz͈̔͊Ȍꍇ̂ƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord06() {
		// ݒt@Cǂݍ
		target.initialize(CONFIG_READER_PARSE_ERROR3);

		//t@CI[vB
		target.open();

		// f[^擾B
		record = target.nextRecord();

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * f[^t@C̃tB[h̒̏ꍇAOȂƂmFB
	 */
	@Test
	public void testNextRecord07() {
		// ݒt@Cǂݍ
		target.initialize(CONFIG_READER_PARSE_ERROR4);

		//t@CI[vB
		target.open();

		// f[^擾B
		record = target.nextRecord();

		// t@CN[YB
		target.close();
	}

	/**
	 * {@link FixedLengthRecordReader#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testInitialize() {
		target.initialize(CONFIG_READER1);
		//t@CI[vB
		target.open();
		// t@CN[YB
		target.close();

	}

	/**
	 * {@link FixedLengthRecordReader#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * ɑ݂ȂL[iݒt@Cjw肵ƂɗO邱ƂmFB
	 */
	@Test(expected = ConfigFileNotFoundException.class)
	public void testInitializeConfigFileNotFoundException() {
		target.initialize("aaa");
	}

	/**
	 * {@link FixedLengthRecordReader#nextRecord()} ̂߂̃eXgE\bhB
	 * f[^t@C̃tH[}bgs̏ꍇAO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testNextRecord08() {
		// ݒt@Cǂݍ
		target.initialize(CONFIG_READER_PARSE_ERROR5);

		//t@CI[vB
		target.open();

		// f[^擾B
		record = target.nextRecord();

		// t@CN[YB
		target.close();
	}
}
