/*
 * XMLAttributeTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.math.BigDecimal;
import java.text.DateFormat;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.exception.DataFormatException;
import junit.framework.Assert;

import org.junit.Test;

/**
 * {@link XMLAttribute} ̃eXgP[XB
 * @author Daisuke Suga
 */
public class XMLAttributeTest {

	XMLAttribute target = null;

	/**
	 * {@link XMLAttribute#XMLAttribute(String, Object)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLAttributeStringObject() {
		target = new XMLAttribute("test1", "aaa1");
	}

	/**
	 * {@link XMLAttribute#XMLAttribute(String, Object, String, String, String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testXMLAttributeStringObjectStringStringString() {
		target = new XMLAttribute("test2", "aaa2", "bbb2", "ccc2", "ddd2");
	}

	/**
	 * {@link XMLAttribute#getName()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetName() {

		String expected1 = "test1";
		String expected2 = "test2";

		target = new XMLAttribute(expected1, "aaa1");
		Assert.assertEquals(expected1, target.getName());

		target = new XMLAttribute(expected2, "aaa2", "bbb2", "ccc2", "ddd2");
		Assert.assertEquals(expected2, target.getName());
	}

	/**
	 * {@link XMLAttribute#getString()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetString() {

		String expected1 = "aaa1";
		String expected2 = "aaa2";

		target = new XMLAttribute("test1", expected1);
		Assert.assertEquals(expected1, target.getString());

		target = new XMLAttribute("test2", expected2, "bbb2", "ccc2", "ddd2");
		Assert.assertEquals(expected2, target.getString());
	}

	/**
	 * {@link XMLAttribute#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetInteger() {
		String expected = "10";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(new Integer(expected), target.getInteger());
	}

	/**
	 * {@link XMLAttribute#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetIntegerDataFormatException() {
		target = new XMLAttribute("test1", "aaa1");
		target.getInteger();
	}

	/**
	 * {@link XMLAttribute#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetIntegerDataFormatException2() {
		target = new XMLAttribute("test1", "aaa1", "bbb1", "ccc1", "ddd1");
		target.getInteger();
	}

	/**
	 * {@link XMLAttribute#getLong()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetLong() {
		String expected = "10";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(new Long(expected), target.getLong());
	}

	/**
	 * {@link XMLAttribute#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetLongDataFormatException() {
		target = new XMLAttribute("test1", "aaa1");
		target.getLong();
	}

	/**
	 * {@link XMLAttribute#getInteger()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetLongDataFormatException2() {
		target = new XMLAttribute("test1", "aaa1", "bbb1", "ccc1", "ddd1");
		target.getLong();
	}

	/**
	 * {@link XMLAttribute#getFloat()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetFloat() {
		String expected = "1.1";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(new Float(expected), target.getFloat());
	}

	/**
	 * {@link XMLAttribute#getFloat()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetFloatDataFormatException() {
		target = new XMLAttribute("test1", "aaa1");
		target.getFloat();
	}

	/**
	 * {@link XMLAttribute#getFloat()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetFloatDataFormatException2() {
		target = new XMLAttribute("test1", "aaa1", "bbb1", "ccc1", "ddd1");
		target.getFloat();
	}

	/**
	 * {@link XMLAttribute#getShort()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetShort() {
		String expected = "10";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(new Short(expected), target.getShort());
	}

	/**
	 * {@link XMLAttribute#getShort()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetShortDataFormatException() {
		target = new XMLAttribute("test1", "aaa1");
		target.getShort();
	}

	/**
	 * {@link XMLAttribute#getShort()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetShortDataFormatException2() {
		target = new XMLAttribute("test1", "aaa1", "bbb1", "ccc1", "ddd1");
		target.getShort();
	}

	/**
	 * {@link XMLAttribute#getBigDecimal()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetBigDecimal() {
		String expected = "10";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(new BigDecimal(expected), target.getBigDecimal());
	}

	/**
	 * {@link XMLAttribute#getBigDecimal()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetBigDecimalDataFormatException() {
		target = new XMLAttribute("test1", "aaa1");
		target.getBigDecimal();
	}

	/**
	 * {@link XMLAttribute#getBigDecimal()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetBigDecimalDataFormatException2() {
		target = new XMLAttribute("test1", "aaa1", "bbb1", "ccc1", "ddd1");
		target.getBigDecimal();
	}

	/**
	 * {@link XMLAttribute#getDate()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetDate() throws Exception {
		String expected = "2008/07/03";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(DateFormat.getDateInstance().parse(expected), target.getDate());
	}

	/**
	 * {@link XMLAttribute#getDate()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetDateDataFormatException() {
		target = new XMLAttribute("test1", "aaa1");
		target.getDate();
	}

	/**
	 * {@link XMLAttribute#getDate()} ̂߂̃eXgE\bhB<br>
	 * l̕ϊsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFormatException.class)
	public void testGetDateDataFormatException2() {
		target = new XMLAttribute("test1", "aaa1", "bbb1", "ccc1", "ddd1");
		target.getDate();
	}

	/**
	 * {@link XMLAttribute#getURI()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetURI() {
		String expected = "test uri";
		target = new XMLAttribute("test1", "aaa1");
		target.setURI(expected);
		Assert.assertEquals(expected, target.getURI());
	}

	/**
	 * {@link XMLAttribute#setURI(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetURI() {
		String expected = "test uri";
		target = new XMLAttribute("test1", "aaa1");
		target.setURI(expected);
	}

	/**
	 * {@link XMLAttribute#getQName()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetQName() {
		String expected = "test qname";
		target = new XMLAttribute("test1", "aaa1");
		target.setQName(expected);
		Assert.assertEquals(expected, target.getQName());
	}

	/**
	 * {@link XMLAttribute#setQName(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testSetQName() {
		String expected = "test:qname";
		target = new XMLAttribute("test1", "aaa1");
		target.setQName(expected);
	}

	/**
	 * {@link XMLAttribute#toString()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testToString() {
		String expected = "aaa1";
		target = new XMLAttribute("test1", expected);
		Assert.assertEquals(expected, target.toString());
	}

}
