/*
 * XMLAttributesTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.util.LinkedHashMap;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttributes;
import junit.framework.Assert;

import org.junit.Test;

/**
 * {@link XMLAttributes} ̃eXgP[XB
 * @author Daisuke Suga
 */
public class XMLAttributesTest {

	XMLAttributes target = null;

	/**
	 * {@link XMLAttributes#getAttribute(String)} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testGetAttribute() {
		XMLAttribute expected1 = new XMLAttribute("test1", "aaa1");
		XMLAttribute expected2 = new XMLAttribute("test2", "aaa2");
		target = new XMLAttributes();
		target.putAttribute(expected1);
		target.putAttribute(expected2);
		Assert.assertEquals(expected1, target.getAttribute("test1"));
		Assert.assertEquals(expected2, target.getAttribute("test2"));
	}

	/**
	 * {@link XMLAttributes#putAttribute(XMLAttribute)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testPutAttribute() {
		target = new XMLAttributes();
		target.putAttribute(new XMLAttribute("test1", "aaa1"));
		target.putAttribute(new XMLAttribute("test2", "aaa2"));
	}

	/**
	 * {@link XMLAttributes#keySet()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testKeySet() {
		String key1 = "test1";
		String key2 = "test2";
		String value1 = "aaa1";
		String value2 = "aaa2";
		LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
		expected.put(key1, value1);
		expected.put(key2, value2);

		target = new XMLAttributes();
		target.putAttribute(new XMLAttribute(key1, value1));
		target.putAttribute(new XMLAttribute(key2, value2));
		Assert.assertEquals(expected.keySet().toString(), target.keySet().toString());
	}

	/**
	 * {@link XMLAttributes#keySet()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testEntrySet() {
		String key1 = "test1";
		String key2 = "test2";
		String value1 = "aaa1";
		String value2 = "aaa2";
		LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
		expected.put(key1, value1);
		expected.put(key2, value2);

		target = new XMLAttributes();
		target.putAttribute(new XMLAttribute(key1, value1));
		target.putAttribute(new XMLAttribute(key2, value2));
		Assert.assertEquals(expected.entrySet().toString(), target.entrySet().toString());
	}

	/**
	 * {@link XMLAttributes#values()} ̂߂̃eXgE\bhB<br>
	 * l擾ł邱ƂmFB
	 */
	@Test
	public void testValues() {
		String key1 = "test1";
		String key2 = "test2";
		String value1 = "aaa1";
		String value2 = "aaa2";
		LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
		expected.put(key1, value1);
		expected.put(key2, value2);

		target = new XMLAttributes();
		target.putAttribute(new XMLAttribute(key1, value1));
		target.putAttribute(new XMLAttribute(key2, value2));
		Assert.assertEquals(expected.values().toString(), target.values().toString());
	}

}
