/*
 * XMLFileReaderImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLElement;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLFileReaderImpl;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLPath;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFileParseException;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/**
 * {@link XMLFileReaderImpl} ̃eXgP[XB
 * @author Daisuke Suga
 */
public class XMLFileReaderImplTest {

	XMLFileReaderImpl target = null;

	/** ǂݍݗp t@C */
	private static final String CONFIG_READER1 = "jp/co/cybec/cb3/accessor/fileaccess/xml/reader1Config";

	/** ǂݍݗp f[^t@C݂Ȃ */
	private static final String CONFIG_READER_FILE_NOT_FOUND = "jp/co/cybec/cb3/accessor/fileaccess/xml/readerFileNotFoundConfig";

	/** ǂݍݗp f[^t@C̋LqȂ */
	private static final String CONFIG_READER_PARSE_ERROR = "jp/co/cybec/cb3/accessor/fileaccess/xml/readerParseErrorConfig";

	/** f[^t@C */
	private static final String FILE_NORMAL= "src/test/testdata/xml/reader1.xml";

	@Before
	public void setUp() {
		target = new XMLFileReaderImpl();
	}

	@After
	public void tearDown() {
		target.release();
	}

	/**
	 * {@link XMLFileReaderImpl#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testInitialize() {
		target.initialize(CONFIG_READER1);
	}

	/**
	 * {@link XMLFileReaderImpl#initialize(String)} ̂߂̃eXgE\bhB<br>
	 * ɑ݂ȂL[iݒt@Cjw肵ƂɗO邱ƂmFB
	 */
	@Test(expected = ConfigFileNotFoundException.class)
	public void testInitializeConfigFileNotFoundException() {
		target.initialize("aaa");
	}

	/**
	 * {@link XMLFileReaderImpl#open()} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testOpen() {
		target.initialize(CONFIG_READER1);
		target.open();
	}

	/**
	 * {@link XMLFileReaderImpl#open()} ̂߂̃eXgE\bhB<br>
	 * QI[vƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorAlreadyOpenedException.class)
	public void testOpenAccessorAlreadyOpenedException() {
		target.initialize(CONFIG_READER1);
		target.open();
		target.open();
	}

	/**
	 * {@link XMLFileReaderImpl#open()} ̂߂̃eXgE\bhB<br>
	 * f[^t@C݂ȂƂɗO邱ƂmFB
	 */
	@Test(expected = DataFileNotFoundException.class)
	public void testOpenDataFileNotFoundException() {
		target.initialize(CONFIG_READER_FILE_NOT_FOUND);
		target.open();
	}

	/**
	 * {@link XMLFileReaderImpl#open()} ̂߂̃eXgE\bhB<br>
	 * f[^t@C̓ǂݍ݂ɎsƂɗO邱ƂmFB
	 */
	@Ignore("DataFileIOException𔭐Ȃ")
	@Test(expected = DataFileIOException.class)
	public void testOpenDataFileIOException() {
	}

	/**
	 * {@link XMLFileReaderImpl#open()} ̂߂̃eXgE\bhB<br>
	 * f[^t@C̉͂ɎsƂɗO邱ƂmFB
	 */
	@Test(expected = DataFileParseException.class)
	public void testOpenDataFileParseException() {
		target.initialize(CONFIG_READER_PARSE_ERROR);
		target.open();
	}

	/**
	 * {@link XMLFileReaderImpl#open(String)} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testOpenString() {
		target.initialize(CONFIG_READER1);
		target.open(FILE_NORMAL);
	}

	/**
	 * {@link XMLFileReaderImpl#open(String)} ̂߂̃eXgE\bhB
	 * f[^t@Cnull̎ɗO邱ƂmFB
	 */
	@Test(expected = DataFileNotFoundException.class)
	public void testOpenStringNullFilepath() {
		target.initialize(CONFIG_READER1);
		target.open(null);
	}

	/**
	 * {@link XMLFileReaderImpl#close()} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testClose() {
		target.initialize(CONFIG_READER1);
		target.open();
		target.close();
		target.open();
	}

	/**
	 * {@link XMLFileReaderImpl#close()} ̂߂̃eXgE\bhB<br>
	 * f[^t@CI[vĂȂĂOȂƂmFB
	 */
	@Test
	public void testCloseNotOpen() {
		target.initialize(CONFIG_READER1);
		target.close();
	}

	/**
	 * {@link XMLFileReaderImpl#close()} ̂߂̃eXgE\bhB<br>
	 * f[^t@C̃N[YɎsƂɗO邱ƂmFB
	 */
	@Ignore("DataFileIOException𔭐Ȃ")
	@Test(expected = DataFileIOException.class)
	public void testCloseDataFileIOException() {
	}

	/**
	 * {@link XMLFileReaderImpl#close()} ̂߂̃eXgE\bhB<br>
	 * OȂƂmFB
	 */
	@Test
	public void testRelease() {
		target.initialize(CONFIG_READER1);
		target.open();
		target.release();
		target.open();
	}

	/**
	 * {@link XMLFileReaderImpl#close()} ̂߂̃eXgE\bhB<br>
	 * f[^t@CI[vĂȂĂOȂƂmFB
	 */
	@Test
	public void testReleaseNotOpen() {
		target.initialize(CONFIG_READER1);
		target.release();
	}

	/**
	 * {@link XMLFileReaderImpl#selectPath(String)} ̂߂̃eXgE\bhB<br>
	 * lł邱ƂmFB
	 */
	@Test
	public void testSelectPath() {
		target.initialize(CONFIG_READER1);
		target.open();

		XMLPath path = target.selectPath("*/dept/code");
		Assert.assertNotNull(path);

		XMLElement element = path.next();
		Assert.assertNotNull(element);

		Assert.assertEquals("10", element.getString());
	}

	/**
	 * {@link XMLFileReaderImpl#selectPath(String)} ̂߂̃eXgE\bhB<br>
	 * f[^t@CI[vĂȂƂɗO邱ƂmFB
	 */
	@Test(expected = AccessorNotOpenException.class)
	public void testSelectPathAccessorNotOpenException() {
		target.initialize(CONFIG_READER1);
		target.selectPath("*/dept/code");
	}

}
