/*
 * LoggingAspectTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.aspect;

import java.io.StringWriter;

import jp.co.cybec.cb3.aspect.LoggingAspect;
import jp.co.cybec.cb3.container.provider.ServiceProvider;
import jp.co.cybec.cb3.mock.container.provider.MockServiceProvider;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import junit.framework.Assert;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * LoggingAspect̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class LoggingAspectTest {

	/** eXgpOC^[ */
	private StringWriter logWriter = new StringWriter();

	/** AvP[VReLXg */
	private ApplicationContext context = null;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {

		// ݒt@Cǂݍ݁B
		context = new ClassPathXmlApplicationContext(
				new String[]{
						"jp/co/cybec/cb3/aspect/applicationContext.xml"
				}
		);

		// Logger쐬
		Logger logger = Logger.getLogger(LoggingAspect.class);
		logger.setLevel(Level.INFO);

		// p^[肷
		PatternLayout layout = new PatternLayout("%m%n");
		WriterAppender appender = new WriterAppender(layout,logWriter);

		// Appendero^
		logger.addAppender(appender);
	}

	/**
	 * {@link jp.co.cybec.cb3.aspect.LoggingAspect#around(org.aspectj.lang.ProceedingJoinPoint)} ̂߂̃eXgE\bhB
	 * ɓnꂽWCg|Cg̃\bhsA߂lԂ邱ƂmFB
	 * ܂Ag[XOo͂Ă邱ƂmFB
	 */
	@Test
	public void testAround() {
		String expectedStartMessage = "[" + MockServiceProvider.class.getName() + "#callService] \bhJn܂B";
		String expectedEndMessage = "[" + MockServiceProvider.class.getName() + "#callService] \bhI܂B";

		// T[rXvoC_𐶐B
		ServiceProvider serviceProvider = (ServiceProvider)context.getBean("test");

		// T[rXsA߂lƂmFB
		int returnCode = serviceProvider.callService(new ServiceParameters(), new RuntimeParameters(null));
		Assert.assertEquals(0, returnCode);

		// g[XOo͂Ă邱ƂmFB
		StringBuffer logBuffer = logWriter.getBuffer();
		int startMessageIndex = logBuffer.indexOf(expectedStartMessage);
		Assert.assertTrue(startMessageIndex > -1);
		Assert.assertTrue(logBuffer.indexOf(expectedEndMessage) > startMessageIndex);
	}

}
