/*
 * ServiceProviderFactoryTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.container.provider;

import jp.co.cybec.cb3.container.provider.ServiceProviderFactory;
import jp.co.cybec.cb3.exception.ServiceProviderCreationException;
import jp.co.cybec.cb3.mock.accessor.MockAccessor;
import jp.co.cybec.cb3.mock.accessor.MockDataAccessContext;
import jp.co.cybec.cb3.mock.container.provider.MockServiceProvider;
import jp.co.cybec.cb3.mock.container.service.MockService;
import jp.co.cybec.cb3.util.CB3BeanFactory;
import junit.framework.Assert;

import org.junit.Test;


/**
 * ServiceProviderFactorỹeXgP[XB
 * @author Naoko Sugimoto
 */
public class ServiceProviderFactoryTest {

	/** AvP[VReLXgt@CpX */
	private static String TEST_CONTEXT_PATH = "jp/co/cybec/cb3/container/provider/ServiceProviderFactory/applicationContext.xml";

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderFactory#getInstance()} ̂߂̃eXgE\bhB
	 * VOgɂȂĂ邱ƂmFB
	 */
	@Test
	public void testGetInstance() {
		Assert.assertSame(ServiceProviderFactory.getInstance(), ServiceProviderFactory.getInstance());
	}

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderFactory#getServiceProvider(String)} ̂߂̃eXgE\bhB
	 * t@CɎw肵ƂɃCX^Xł邱ƂmFB
	 */
	@Test
	public void testGetServiceProvider() {

		// eXgp̃ReLXgt@CpXgp
		CB3BeanFactory.getInstance().setApplicationContextFilePath(TEST_CONTEXT_PATH);

		// T[rXvoC_擾B
		ServiceProviderFactory factory = ServiceProviderFactory.getInstance();
		MockServiceProvider serviceProvider = (MockServiceProvider)factory.getServiceProvider("test");
		// T[rX擾B
		MockService service = (MockService)serviceProvider.getService();
		// f[^ANZXReLXg擾B
		MockDataAccessContext dataAccessContext = (MockDataAccessContext)service.getDataAccessContext();
		// ANZbT擾B
		MockAccessor accessor1 = (MockAccessor)dataAccessContext.lookup("accessor1");
		MockAccessor accessor2 = (MockAccessor)dataAccessContext.lookup("accessor2");
		// ANZbTʂ̃CX^Xł邱ƂmFBiVOgɂȂĂȂBj
		Assert.assertNotSame(accessor1, accessor2);
	}

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderFactory} ̂߂̃eXgE\bhB
	 * ݒt@C݂ȂꍇAK؂ȗO邱ƂmFB
	 */
	@Test(expected=ServiceProviderCreationException.class)
	public void testGetServiceProviderFileNotFound() {
		// ftHg̃f[^\[XReLXgt@CpXgp
		CB3BeanFactory.getInstance().setApplicationContextFilePath("dummy.xml");

		// T[rXvoC_擾悤ƂƁAOB
		ServiceProviderFactory.getInstance().getServiceProvider("test");
	}

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderFactory} ̂߂̃eXgE\bhB
	 * ݂ȂBean IDw肵ꍇAK؂ȗO邱ƂmFB
	 */
	@Test(expected=ServiceProviderCreationException.class)
	public void testGetServiceProviderBeanNotFound() {
		// eXgp̃ReLXgt@CpXgp
		CB3BeanFactory.getInstance().setApplicationContextFilePath(TEST_CONTEXT_PATH);

		// ݂ȂIDw肵āAT[rXvoC_擾悤ƂƁAOB
		ServiceProviderFactory.getInstance().getServiceProvider("dummy");
	}
}
