/*
 * ServiceProviderImplTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.container.provider;

import java.util.HashMap;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.container.provider.ServiceProviderImpl;
import jp.co.cybec.cb3.mock.accessor.MockDataAccessContext;
import jp.co.cybec.cb3.mock.container.service.MockService;
import jp.co.cybec.cb3.mock.util.MockApplicationExiter;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.ApplicationExiterDelegater;
import jp.co.cybec.cb3.util.CB3BeanFactory;
import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;


/**
 * ServiceProviderImpl̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class ServiceProviderImplTest {

	@Before
	public void setUp() {
		// ݒt@CQƐeXgpɐ؂ւ
		CB3BeanFactory.getInstance().setApplicationContextFilePath("jp/co/cybec/cb3/container/provider/ServiceProviderImpl/applicationContext.xml");
		// SystemReturnerbNɐ؂ւBmain()\bh̃eXgŁASystem.exit()Ă΂ƃeXgłȂ߁B
		ApplicationExiterDelegater.getInstance().setApplicationExiter(new MockApplicationExiter());
	}

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderImpl#main(java.lang.String[])} ̂߂̃eXgE\bhB
	 * T[rXs̃eXgB
	 */
	@Test
	public void testMain() {
		// N̈ݒB
		String[] args = new String[]{
				"-ServiceName", "test"
		};
		// mainNB
		ServiceProviderImpl.main(args);
		// sʂmFiIjB
		Assert.assertEquals(0, ApplicationExiterDelegater.getInstance().getReturnCode());
	}

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderImpl#main(java.lang.String[])} ̂߂̃eXgE\bhB
	 * Np[^ɃT[rXw肳ĂȂꍇ̃eXgB
	 */
	@Test
	public void testMainNoServiceParameter() {
		// N̈ݒB
		String[] args = new String[]{};
		// mainNB
		ServiceProviderImpl.main(args);
		// sʂmFiُIjB
		Assert.assertEquals(9, ApplicationExiterDelegater.getInstance().getReturnCode());
	}

	/**
	 * {@link jp.co.cybec.cb3.container.provider.ServiceProviderImpl#callService(jp.co.cybec.cb3.session.ServiceParameters, jp.co.cybec.cb3.session.RuntimeParameters)} ̂߂̃eXgE\bhB
	 * setService()ŃZbgT[rXsł邱ƂmFB
	 */
	@Test
	public void testCallService() {
		// T[rXvoC_ɓnT[rXgݗĂB
		MockDataAccessContext dataAccessContext = new MockDataAccessContext(new HashMap<String, Accessor>());
		MockService service = new MockService();
		service.setDataAccessContext(dataAccessContext);

		// T[rXvoC_𐶐B
		ServiceProviderImpl provider = new ServiceProviderImpl();
		provider.setService(service);

		// T[rXsB
		provider.callService(new ServiceParameters(), new RuntimeParameters(null));

		// T[rXsĂ邱ƂmFB
		Assert.assertTrue(service.isExecuted());

	}
}
