/*
 * ConfigFileIOExceptionTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.exception;

import jp.co.cybec.cb3.exception.ConfigFileIOException;
import junit.framework.Assert;
import org.junit.Test;

/**
 * ConfigFileIOExceptioñeXgP[XB
 * @author Naoko Sugimoto
 */
public class ConfigFileIOExceptionTest {

	/**
	 * {@link jp.co.cybec.cb3.exception.ConfigFileIOException#ConfigFileIOException(java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);

		// ConfigFileIOException𐶐B
		ConfigFileIOException newException = new ConfigFileIOException(causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(causeMessage));
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.ConfigFileIOException#ConfigFileIOException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithString() {
		String message = "XXXXɎs܂B";

		// ConfigFileIOException𐶐B
		ConfigFileIOException newException = new ConfigFileIOException(message);

		// bZ[WemFB
		Assert.assertEquals(message, newException.getMessage());
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.ConfigFileIOException#ConfigFileIOException(java.lang.String, java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithStringAndException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);
		// Vǉ郁bZ[WB
		String newMessage = "YYYY̏ɗO܂B";

		// ConfigFileIOException𐶐B
		ConfigFileIOException newException = new ConfigFileIOException(newMessage, causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(newMessage));
	}

}
