/*
 * ConfigFileNotFoundExceptionTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.exception;

import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import junit.framework.Assert;
import org.junit.Test;

/**
 * ConfigFileNotFoundExceptioñeXgP[XB
 * @author Naoko Sugimoto
 */
public class ConfigFileNotFoundExceptionTest {

	/**
	 * {@link jp.co.cybec.cb3.exception.ConfigFileNotFoundException#ConfigFileNotFoundException(java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);

		// ConfigFileNotFoundException𐶐B
		ConfigFileNotFoundException newException = new ConfigFileNotFoundException(causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(causeMessage));
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.ConfigFileNotFoundException#ConfigFileNotFoundException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithString() {
		String message = "XXXXɎs܂B";

		// ConfigFileNotFoundException𐶐B
		ConfigFileNotFoundException newException = new ConfigFileNotFoundException(message);

		// bZ[WemFB
		Assert.assertEquals(message, newException.getMessage());
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.ConfigFileNotFoundException#ConfigFileNotFoundException(java.lang.String, java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithStringAndException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);
		// Vǉ郁bZ[WB
		String newMessage = "YYYY̏ɗO܂B";

		// ConfigFileNotFoundException𐶐B
		ConfigFileNotFoundException newException = new ConfigFileNotFoundException(newMessage, causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(newMessage));
	}

}
