/*
 * RuntimeArgumentsAnalyzeExceptionTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.exception;

import jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException;
import junit.framework.Assert;
import org.junit.Test;

/**
 * RuntimeArgumentsAnalyzeExceptioñeXgP[XB
 * @author Naoko Sugimoto
 */
public class RuntimeArgumentsAnalyzeExceptionTest {

	/**
	 * {@link jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException#RuntimeArgumentsAnalyzeException(java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);

		// RuntimeArgumentsAnalyzeException𐶐B
		RuntimeArgumentsAnalyzeException newException = new RuntimeArgumentsAnalyzeException(causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(causeMessage));
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException#RuntimeArgumentsAnalyzeException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithString() {
		String message = "XXXXɎs܂B";

		// RuntimeArgumentsAnalyzeException𐶐B
		RuntimeArgumentsAnalyzeException newException = new RuntimeArgumentsAnalyzeException(message);

		// bZ[WemFB
		Assert.assertEquals(message, newException.getMessage());
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException#RuntimeArgumentsAnalyzeException(java.lang.String, java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithStringAndException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);
		// Vǉ郁bZ[WB
		String newMessage = "YYYY̏ɗO܂B";

		// RuntimeArgumentsAnalyzeException𐶐B
		RuntimeArgumentsAnalyzeException newException = new RuntimeArgumentsAnalyzeException(newMessage, causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(newMessage));
	}

}
