/*
 * ServiceRuntimeExceptionTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.exception;

import jp.co.cybec.cb3.exception.ServiceRuntimeException;
import junit.framework.Assert;
import org.junit.Test;

/**
 * ServiceRuntimeExceptioñeXgP[XB
 * @author Naoko Sugimoto
 */
public class ServiceRuntimeExceptionTest {

	/**
	 * {@link jp.co.cybec.cb3.exception.ServiceRuntimeException#ServiceRuntimeException(java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);

		// ServiceRuntimeException𐶐B
		ServiceRuntimeException newException = new ServiceRuntimeException(causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(causeMessage));
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.ServiceRuntimeException#ServiceRuntimeException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithString() {
		String message = "XXXXɎs܂B";

		// ServiceRuntimeException𐶐B
		ServiceRuntimeException newException = new ServiceRuntimeException(message);

		// bZ[WemFB
		Assert.assertEquals(message, newException.getMessage());
	}

	/**
	 * {@link jp.co.cybec.cb3.exception.ServiceRuntimeException#ServiceRuntimeException(java.lang.String, java.lang.Exception)} ̂߂̃eXgE\bhB
	 */
	@Test
	public void testConstructorWithStringAndException() {
		// ɂȂO𐶐B
		String causeMessage = "XXXXɎs܂B";
		Exception causeException = new Exception(causeMessage);
		// Vǉ郁bZ[WB
		String newMessage = "YYYY̏ɗO܂B";

		// ServiceRuntimeException𐶐B
		ServiceRuntimeException newException = new ServiceRuntimeException(newMessage, causeException);

		// ɂȂOێĂ邱ƂmFB
		Assert.assertSame(causeException, newException.getCause());
		// bZ[WemFB
		Assert.assertEquals(0, newException.getMessage().indexOf(newMessage));
	}

}
