/*
 * RuntimeParametersTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.session;


import java.util.HashMap;
import java.util.LinkedHashMap;

import jp.co.cybec.cb3.session.RuntimeParameters;
import junit.framework.Assert;
import org.junit.Test;

/**
 * RuntimeParameters̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class RuntimeParametersTest {

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeParameters} ̂߂̃eXgE\bhB
	 * RXgN^Őݒ肵p[^A{@link jp.co.cybec.cb3.session.RuntimeParameters#get(String)}
	 * 擾ł邱ƂmFB
	 */
	@Test
	public void testNomalParameters() {

		HashMap<String, String> parameterMap = new HashMap<String, String>();
		parameterMap.put("key1", "value1");
		parameterMap.put("key2", null);

		// RuntimeParameters𐶐B
		RuntimeParameters runtimeParameters = new RuntimeParameters(parameterMap);

		// RuntimeParametersɋNp[^ZbgĂ邱ƂmFB
		Assert.assertEquals("value1", runtimeParameters.get("key1"));
		Assert.assertNull(runtimeParameters.get("key2"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeParameters} ̂߂̃eXgE\bhB
	 * RXgN^nullw肳ꂽꍇAG[ɂȂȂƂmFB
	 */
	@Test
	public void testNullParameters() {

		// RuntimeParameters𐶐BG[ɂȂȂB
		RuntimeParameters runtimeParameters = new RuntimeParameters(null);

		// RuntimeParametersĂB
		Assert.assertNull(runtimeParameters.get("dummy"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeParameters#containsKey(String)} ̂߂̃eXgE\bhB
	 * p[^ێĂL[w肵ƂAtrueԂ邱ƂmFB
	 */
	@Test
	public void testContainsKey() {
		HashMap<String, String> parameterMap = new HashMap<String, String>();
		parameterMap.put("key1", "value1");
		parameterMap.put("key2", null);

		// RuntimeParameters𐶐B
		RuntimeParameters runtimeParameters = new RuntimeParameters(parameterMap);

		// RuntimeParametersɋNp[^ZbgĂ邱ƂmFB
		Assert.assertTrue(runtimeParameters.containsKey("key1"));
		Assert.assertTrue(runtimeParameters.containsKey("key2"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeParameters#containsKey(String)} ̂߂̃eXgE\bhB
	 * p[^ێĂȂL[w肵ƂAfakseԂ邱ƂmFB
	 */
	@Test
	public void testContainsKeyNothing() {
		HashMap<String, String> parameterMap = new HashMap<String, String>();
		parameterMap.put("key1", "value1");

		// RuntimeParameters𐶐B
		RuntimeParameters runtimeParameters = new RuntimeParameters(parameterMap);

		// RuntimeParametersɋNp[^ZbgĂ邱ƂmFB
		Assert.assertFalse(runtimeParameters.containsKey("dummy"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.RuntimeParameters#toString()} ̂߂̃eXgE\bhB
	 * toString()Ńp[^̒g\邱ƂmFB
	 */
	@Test
	public void testToString() {
		HashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
		parameterMap.put("key1", "value1");
		parameterMap.put("key2", null);

		// RuntimeParameters𐶐B
		RuntimeParameters runtimeParameters = new RuntimeParameters(parameterMap);

		String expected = "RuntimeParameters{key1=value1, key2=null}";
		// toString()̌ʂmFB
		Assert.assertEquals(expected, runtimeParameters.toString());
	}
}
