/*
 * ServiceParametersTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.session;


import java.util.ArrayList;
import java.util.HashMap;

import jp.co.cybec.cb3.session.ServiceParameters;
import junit.framework.Assert;

import org.junit.Test;

/**
 * ServiceParameters̃eXgP[XB
 * @author Naoko Sugimoto
 */
public class ServiceParametersTest {

	/**
	 * {@link jp.co.cybec.cb3.session.ServiceParameters} ̂߂̃eXgE\bhB
	 * p[^̐ݒƎ擾ɍs邱ƂmFB
	 */
	@Test
	public void testPutAndGet() {

		// ServiceParameters𐶐B
		ServiceParameters serviceParameters = new ServiceParameters();

		// p[^ɕۑf[^𐶐B
		ArrayList<String> dataList = new ArrayList<String>();
		dataList.add("data1-1");
		dataList.add("data1-2");

		HashMap<String, Object> dataMap = new HashMap<String, Object>();
		dataMap.put("1", 100);
		dataMap.put("2", 200);

		// p[^ݒ肷B
		serviceParameters.put("key1", dataList);
		serviceParameters.put("key2", dataMap);
		serviceParameters.put("key3", "data3");

		// p[^擾AʂƂmFB
		Assert.assertSame(dataList, serviceParameters.get("key1"));
		Assert.assertSame(dataMap, serviceParameters.get("key2"));
		Assert.assertSame("data3", serviceParameters.get("key3"));
		Assert.assertNull(serviceParameters.get("key4"));
	}

	/**
	 * {@link jp.co.cybec.cb3.session.ServiceParameters#toString()} ̂߂̃eXgE\bhB
	 * toString()Ńp[^̒g\邱ƂmFB
	 */
	@Test
	public void testToString() {
		// ServiceParameters𐶐B
		ServiceParameters serviceParameters = new ServiceParameters();

		// p[^𐶐B
		serviceParameters.put("key1", "data1");
		serviceParameters.put("key2", "data2");

		// toString()̌ʂmFB
		String expected1 = "ServiceParameters{key1=data1, key2=data2}";
		String expected2 = "ServiceParameters{key2=data2, key1=data1}";
		String result = serviceParameters.toString();
		Assert.assertTrue(result.equals(expected1) || result.equals(expected2));
	}
}
