/*
 * DateUtilTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.co.cybec.cb3.util.DateUtil;
import junit.framework.Assert;

import org.junit.Test;

/**
 * DateUtil̃eXgP[XB
 * @author Jianming Guo
 */
public class DateUtilTest {

	/**
	 * {@link DateUtil#parseDate(String)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 */
	@Test
	public void testParseDate() throws ParseException{
		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		Date expected = df.parse("20080721 152135");

		Date result = DateUtil.parseDate("2008/07/21 15:21:35");
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#parseDate(String)} ̂߂̃eXgE\bhB<br>
	 * t̃tH[}bgftH[ĝƈقȂꍇAO邱ƂmFB
	 */
	@Test(expected = ParseException.class)
	public void testParseDateParseException1() throws ParseException {
		DateUtil.parseDate("2008-07-21 15:21:35");
	}

	/**
	 * {@link DateUtil#parseDate(String)} ̂߂̃eXgE\bhB<br>
	 * 񂪓tȂꍇAO邱ƂmFB
	 */
	@Test(expected = ParseException.class)
	public void testParseDateParseException2() throws ParseException {
		DateUtil.parseDate("200ba021");
	}

	/**
	 * {@link DateUtil#parseDate(String, String)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 *     Nb
	 */
	@Test
	public void testParseDate2() throws ParseException{
		Date expected;
		Date result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		expected = df.parse("20080721 152135");

		// tH[}bgF "yyyyMMdd HHmmss"
		result = DateUtil.parseDate("20080721 152135", "yyyyMMdd HHmmss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd HH:mm:ss"
		result = DateUtil.parseDate("2008/07/21 15:21:35", "yyyy/MM/dd HH:mm:ss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-dd HH:mm:ss"
		result = DateUtil.parseDate("2008-07-21 15:21:35", "yyyy-MM-dd HH:mm:ss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd HH:mm:ss"
		result = DateUtil.parseDate("2008.07.21 15:21:35", "yyyy.MM.dd HH:mm:ss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd HHmmssb"
		result = DateUtil.parseDate("2008N0721 152135b", "yyyyNMMdd HHmmssb");
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#parseDate(String, String)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 *     N
	 */
	@Test
	public void testParseDate3() throws ParseException{
		Date expected;
		Date result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmm");
		expected = df.parse("20080721 1521");

		// tH[}bgF "yyyyMMdd HHmm"
		result = DateUtil.parseDate("20080721 1521", "yyyyMMdd HHmm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd HH:mm"
		result = DateUtil.parseDate("2008/07/21 15:21", "yyyy/MM/dd HH:mm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-dd HH:mm"
		result = DateUtil.parseDate("2008-07-21 15:21", "yyyy-MM-dd HH:mm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd HH:mm"
		result = DateUtil.parseDate("2008.07.21 15:21", "yyyy.MM.dd HH:mm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd HHmm"
		result = DateUtil.parseDate("2008N0721 1521", "yyyyNMMdd HHmm");
		Assert.assertEquals(expected, result);

	}

	/**
	 * {@link DateUtil#parseDate(String, String)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 *     N
	 */
	@Test
	public void testParseDate4() throws ParseException{
		Date expected;
		Date result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HH");
		expected = df.parse("20080721 15");

		// tH[}bgF "yyyyMMdd HH"
		result = DateUtil.parseDate("20080721 15", "yyyyMMdd HH");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd HH"
		result = DateUtil.parseDate("2008/07/21 15", "yyyy/MM/dd HH");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-dd HH"
		result = DateUtil.parseDate("2008-07-21 15", "yyyy-MM-dd HH");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd HH"
		result = DateUtil.parseDate("2008.07.21 15", "yyyy.MM.dd HH");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd HH"
		result = DateUtil.parseDate("2008N0721 15", "yyyyNMMdd HH");
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#parseDate(String, String)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 *     N
	 */
	@Test
	public void testParseDate5() throws ParseException{
		Date expected;
		Date result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
		expected = df.parse("20080721");

		// tH[}bgF "yyyyMMdd"
		result = DateUtil.parseDate("20080721", "yyyyMMdd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd"
		result = DateUtil.parseDate("2008/07/21", "yyyy/MM/dd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-dd"
		result = DateUtil.parseDate("2008-07-21", "yyyy-MM-dd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd"
		result = DateUtil.parseDate("2008.07.21", "yyyy.MM.dd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd"
		result = DateUtil.parseDate("2008N0721", "yyyyNMMdd");
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#parseDate(String, String)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 *     N
	 */
	@Test
	public void testParseDate6() throws ParseException {
		Date expected;
		Date result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
		expected = df.parse("200807");

		// tH[}bgF "yyyyMM"
		result = DateUtil.parseDate("200807", "yyyyMM");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM"
		result = DateUtil.parseDate("2008/07", "yyyy/MM");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM"
		result = DateUtil.parseDate("2008-07", "yyyy-MM");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM"
		result = DateUtil.parseDate("2008.07", "yyyy.MM");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMM"
		result = DateUtil.parseDate("2008N07", "yyyyNMM");
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#parseDate(String, String)} ̂߂̃eXgE\bhB<br>
	 * ̃tH[}bgw̃tH[}bgƈقȂꍇAO邱ƂmFB
	 */
	@Test(expected = ParseException.class)
	public void testParseDateParseException3() throws ParseException{
		DateUtil.parseDate("2008/07/21 15:21:35", "yyyyMMdd HHmmss");
	}

	/**
	 * {@link DateUtil#parseDate(String, String, boolean)} ̂߂̃eXgE\bhB<br>
	 * t^ɐp[X邱ƂmFB
	 */
	@Test
	public void testParseDate10() throws ParseException {
		Date expected;
		Date result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		expected = df.parse("20080721 152135");

		// tH[}bgF "yyyyMMdd HHmmss"
		result = DateUtil.parseDate("20080721 152135", "yyyyMMdd HHmmss", true);
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd HH:mm:ss"
		result = DateUtil.parseDate("2008/07/21 15:21:35", "yyyy/MM/dd HH:mm:ss", false);
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#formatDate(Date)} ̂߂̃eXgE\bhB<br>
	 * t𐳂tH[}bg邱ƂmFB
	 */
	@Test
	public void testFormatDate1() throws ParseException{
		String expected;
		String result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		Date date = df.parse("20080721 152135");
		expected = "2008/07/21 15:21:35";

		result = DateUtil.formatDate(date);
		Assert.assertEquals(expected, result);

		df = new SimpleDateFormat("yyyyMMdd");
		date = df.parse("20080721");

		expected = "2008/07/21 00:00:00";
		result = DateUtil.formatDate(date);
		Assert.assertEquals(expected, result);
	}

	/**
	 * {@link DateUtil#formatDate(Date, String)} ̂߂̃eXgE\bhB<br>
	 * t𐳂tH[}bg邱ƂmFB
	 *    Nb
	 */
	@Test
	public void testFormatDate2() throws ParseException {
		String expected;
		String result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		Date date = df.parse("20080721 152135");
		// tH[}bgF "yyyyMMdd HHmmss"
		expected = "20080721 152135";
		result = DateUtil.formatDate(null, "yyyyMMdd HHmmss");
		Assert.assertNull(result);


		// tH[}bgF null
		expected = "2008/07/21 15:21:35";
		result = DateUtil.formatDate(date, null);
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyMMdd HHmmss"
		expected = "20080721 152135";
		result = DateUtil.formatDate(date, "yyyyMMdd HHmmss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd HH:mm:ss"
		expected = "2008/07/21 15:21:35";
		result = DateUtil.formatDate(date, "yyyy/MM/dd HH:mm:ss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-dd HH:mm:ss"
		expected = "2008-07-21 15:21:35";
		result = DateUtil.formatDate(date, "yyyy-MM-dd HH:mm:ss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd HH:mm:ss"
		expected = "2008.07.21 15:21:35";
		result = DateUtil.formatDate(date, "yyyy.MM.dd HH:mm:ss");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd HHmmssb"
		expected = "2008N0721 152135b";
		result = DateUtil.formatDate(date, "yyyyNMMdd HHmmssb");
		Assert.assertEquals(expected, result);

	}

	/**
	 * {@link DateUtil#formatDate(Date, String)} ̂߂̃eXgE\bhB<br>
	 * t𐳂tH[}bg邱ƂmFB
	 *    N
	 */
	@Test
	public void testFormatDate3() throws ParseException{
		String expected;
		String result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		Date date = df.parse("20080721 152135");

		// tH[}bgF "yyyyMMdd HHmm"
		expected = "20080721 1521";
		result = DateUtil.formatDate(date, "yyyyMMdd HHmm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd HH:mm"
		expected = "2008/07/21 15:21";
		result = DateUtil.formatDate(date, "yyyy/MM/dd HH:mm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-dd HH:mm"
		expected = "2008-07-21 15:21";
		result = DateUtil.formatDate(date, "yyyy-MM-dd HH:mm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd HH:mm"
		expected = "2008.07.21 15:21";
		result = DateUtil.formatDate(date, "yyyy.MM.dd HH:mm");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd HHmm"
		expected = "2008N0721 1521";
		result = DateUtil.formatDate(date, "yyyyNMMdd HHmm");
		Assert.assertEquals(expected, result);

	}

	/**
	 * {@link DateUtil#formatDate(Date, String)} ̂߂̃eXgE\bhB<br>
	 * t𐳂tH[}bg邱ƂmFB
	 *    N
	 */
	@Test
	public void testFormatDate4() throws ParseException{
		String expected;
		String result;

		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss");
		Date date = df.parse("20080721 152135");

		// tH[}bgF "yyyyMMdd"
		expected = "20080721";
		result = DateUtil.formatDate(date, "yyyyMMdd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy/MM/dd"
		expected = "2008/07/21";
		result = DateUtil.formatDate(date, "yyyy/MM/dd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy-MM-ddm"
		expected = "2008-07-21";
		result = DateUtil.formatDate(date, "yyyy-MM-dd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyy.MM.dd"
		expected = "2008.07.21";
		result = DateUtil.formatDate(date, "yyyy.MM.dd");
		Assert.assertEquals(expected, result);

		// tH[}bgF "yyyyNMMdd"
		expected = "2008N0721";
		result = DateUtil.formatDate(date, "yyyyNMMdd");
		Assert.assertEquals(expected, result);

	}

	/**
	 * {@link DateUtil#parseDate(String, String, boolean)} ̂߂̃eXgE\bhB<br>
	 * tH[}bgȏꍇAO邱ƂmFB
	 */
	@Test(expected = IllegalArgumentException.class)
	public void testFormatDateIllegalArgumentException() {
		// tH[}bgF "yyyyMMdd HHmmss"
		DateUtil.formatDate(new Date(System.currentTimeMillis()), "YYYY");
	}
}
