/*
 * ValidationErrorHandlerTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import jp.co.cybec.cb3.util.ValidationErrorHandler;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

/**
 * ValidationErrorHandler̃eXgP[XB
 * @author Juanjuan Wang
 */
public class ValidationErrorHandlerTest {

	private ValidationErrorHandler myErrorHandler = null;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		myErrorHandler = new ValidationErrorHandler();
	}

	/**
	 * @throws Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link ValidationErrorHandler#isValid()} ̂߂̃eXgE\bhB
	 * Ó،ʁutruev擾ł邱ƂmFB
	 */
	@Test
	public void testIsValid() {
		myErrorHandler.isValid();
		Assert.assertTrue(myErrorHandler.isValid());
	}

	/**
	 * {@link ValidationErrorHandler#error(SAXParseException)} ̂߂̃eXgE\bhB
	 * XMLÓ؂̏ꍇAisValid̒lݒ肳邱ƂmFB
	 */
	@Test
	public void testError() throws Exception {
		SAXParseException exception = new SAXParseException("SAX\͗OError", new LocatorImpl());
		myErrorHandler.error(exception);
		Assert.assertFalse(myErrorHandler.isValid());
	}

	/**
	 * {@link ValidationErrorHandler#fatalError(SAXParseException)} ̂߂̃eXgE\bhB
	 * XMLÓ؂̏ꍇAisValid̒lݒ肳邱ƂmFB
	 */
	@Test
	public void testFatalError() throws Exception {
		SAXParseException exception = new SAXParseException("SAX\͗OFatalError", new LocatorImpl());
		myErrorHandler.fatalError(exception);
		Assert.assertFalse(myErrorHandler.isValid());
	}

	/**
	 * {@link ValidationErrorHandler#warning(SAXParseException)} ̂߂̃eXgE\bhB
	 * XMLÓ؂̏ꍇAisValid̒lݒ肳邱ƂmFB
	 */
	@Test
	public void testWarning() throws Exception {
		SAXParseException exception = new SAXParseException("SAX\͗OWarning", new LocatorImpl());
		myErrorHandler.warning(exception);
		Assert.assertFalse(myErrorHandler.isValid());
	}

}
