/*
 * LogMessageFactoryTest.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util.logging;

import jp.co.cybec.cb3.exception.MessageResourceException;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import jp.co.cybec.cb3.util.logging.LogMessageIdentifier;
import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;

/**
 * LogMessageFactorỹeXgP[XB
 * @author Naoko Sugimoto
 */
public class LogMessageFactoryTest {

	private static String MESSAGE_FILENAME = "jp/co/cybec/cb3/util/LogMessageFactory/" + LogMessageConstant.CB3_MESSAGE_FILENAME;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#LogMessageFactory(java.lang.String)} ̂߂̃eXgE\bhB
	 * ݂ȂvpeBt@Cw肵ƂAK؂ȗO邱ƂmFB
	 */
	@Test
	public void testLogMessageFileNotFound() {
		try {
			// RXgN^ɑ݂Ȃt@CwB
			new LogMessageFactory("dummy");
			// OȂꍇAeXgsB
			Assert.fail();
		} catch (MessageResourceException e) {
			// zʂB
		}
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String)} ̂߂̃eXgE\bhB
	 * bZ[W擾ł邱ƂmFB
	 */
	@Test
	public void testGetMessageString() {
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		String message = MESSAGE.getMessage("CB3.UTIL.001");
		String expected = "MessageID:[CB3.UTIL.001] p[^̂ȂbZ[WB";
		Assert.assertTrue(message.indexOf(expected) > -1);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String)} ̂߂̃eXgE\bhB
	 * vpeBt@Cɑ݂ȂbZ[WIDw肵ƂAbZ[W擾łȂ|̃bZ[W擾ł邱ƂmFB
	 */
	@Test
	public void testGetMessageStringIDNotFound() {
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		// ݂ȂIDwB
		String message = MESSAGE.getMessage("CB3.UTIL.999");
		Assert.assertEquals(
			"bZ[WID[CB3.UTIL.999][" + MESSAGE_FILENAME + ".properties]Ɍ܂B",
			message);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String, java.lang.Object[])} ̂߂̃eXgE\bhB
	 * bZ[W擾ł邱ƂmFB
	 */
	@Test
	public void testGetMessageStringObjectArray() {
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		String message = MESSAGE.getMessage("CB3.UTIL.002", "value1", 123);
		String expected = "MessageID:[CB3.UTIL.002] p[^̂郁bZ[WBparam1=value1,param2=123";
		Assert.assertTrue(message.indexOf(expected) > -1);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String)} ̂߂̃eXgE\bhB
	 * bZ[WʎqǉꂽbZ[W擾ł邱ƂmFBiAdvancedpbP[W`j
	 */
	@Test
	public void testGetMessageIdentifierStringAdvancedFormat() {
		LogMessageIdentifier.setJobProcessId("123");
		LogMessageIdentifier.setJobId("456");
		LogMessageIdentifier.setTaskId("789");
		LogMessageIdentifier.setServiceId("abc");
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		String message = MESSAGE.getMessage("CB3.UTIL.001");
		Assert.assertEquals("JobProcessID:[123] JobID:[456] TaskID:[789] ServiceID:[abc] MessageID:[CB3.UTIL.001] p[^̂ȂbZ[WB", message);
		LogMessageIdentifier.setJobProcessId(null);
		LogMessageIdentifier.setJobId(null);
		LogMessageIdentifier.setTaskId(null);
		LogMessageIdentifier.setServiceId(null);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String)} ̂߂̃eXgE\bhB
	 * bZ[WʎqǉꂽbZ[W擾ł邱ƂmFBiCorepbP[W`j
	 */
	@Test
	public void testGetMessageIdentifierStringCoreFormat() {
		LogMessageIdentifier.setJobProcessId("123");
		LogMessageIdentifier.setJobId(null);
		LogMessageIdentifier.setTaskId(null);
		LogMessageIdentifier.setServiceId("abc");
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		String message = MESSAGE.getMessage("CB3.UTIL.001");
		Assert.assertEquals("JobProcessID:[123] ServiceID:[abc] MessageID:[CB3.UTIL.001] p[^̂ȂbZ[WB", message);
		LogMessageIdentifier.setJobProcessId(null);
		LogMessageIdentifier.setJobId(null);
		LogMessageIdentifier.setTaskId(null);
		LogMessageIdentifier.setServiceId(null);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String, java.lang.Object[])} ̂߂̃eXgE\bhB
	 * bZ[WʎqǉꂽbZ[W擾ł邱ƂmFBiAdvancedpbP[W`j
	 */
	@Test
	public void testGetMessageIdentifierStringObjectArrayAdvancedFormat() {
		LogMessageIdentifier.setJobProcessId("123");
		LogMessageIdentifier.setJobId("456");
		LogMessageIdentifier.setTaskId("789");
		LogMessageIdentifier.setServiceId("abc");
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		String message = MESSAGE.getMessage("CB3.UTIL.002", "value1", 123);
		Assert.assertEquals("JobProcessID:[123] JobID:[456] TaskID:[789] ServiceID:[abc] MessageID:[CB3.UTIL.002] p[^̂郁bZ[WBparam1=value1,param2=123", message);
		LogMessageIdentifier.setJobProcessId(null);
		LogMessageIdentifier.setJobId(null);
		LogMessageIdentifier.setTaskId(null);
		LogMessageIdentifier.setServiceId(null);
	}

	/**
	 * {@link jp.co.cybec.cb3.util.logging.LogMessageFactory#getMessage(java.lang.String, java.lang.Object[])} ̂߂̃eXgE\bhB
	 * bZ[WʎqǉꂽbZ[W擾ł邱ƂmFBiCorepbP[W`j
	 */
	@Test
	public void testGetMessageIdentifierStringObjectArrayCoreFormat() {
		LogMessageIdentifier.setJobProcessId("123");
		LogMessageIdentifier.setJobId(null);
		LogMessageIdentifier.setTaskId(null);
		LogMessageIdentifier.setServiceId("abc");
		LogMessageFactory MESSAGE = new LogMessageFactory(MESSAGE_FILENAME);
		String message = MESSAGE.getMessage("CB3.UTIL.002", "value1", 123);
		Assert.assertEquals("JobProcessID:[123] ServiceID:[abc] MessageID:[CB3.UTIL.002] p[^̂郁bZ[WBparam1=value1,param2=123", message);
		LogMessageIdentifier.setJobProcessId(null);
		LogMessageIdentifier.setJobId(null);
		LogMessageIdentifier.setTaskId(null);
		LogMessageIdentifier.setServiceId(null);
	}

}
