/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecord;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRecord
implements DBRecord {
    private static final Log LOG = LogFactory.getLog(JdbcRecord.class);
    private ResultSet resultSet = null;
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String sql = null;
    private DBQueryParameterMap parameter = null;
    private int row = 0;
    HashMap<String, Object> recordMap = null;
    HashMap<String, String> recordStringMap = null;

    public JdbcRecord(ResultSet rs, String sql, DBQueryParameterMap parameter, int row) {
        this.resultSet = rs;
        this.sql = sql;
        this.parameter = parameter;
        this.row = row;
    }

    @Override
    public Integer getInteger(String columnName) throws DataAccessException {
        try {
            return new Integer(this.resultSet.getInt(columnName));
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.021", "CB3.ACCESSOR.DBACCESS.006", "Integer", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Object getObject(String columnName) throws DataAccessException {
        try {
            return this.resultSet.getObject(columnName);
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.022", "CB3.ACCESSOR.DBACCESS.006", "Object", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public String getString(String columnName) throws DataAccessException {
        try {
            return this.resultSet.getString(columnName);
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.023", "CB3.ACCESSOR.DBACCESS.006", "String", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws DataAccessException {
        try {
            return this.resultSet.getBigDecimal(columnName);
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.024", "CB3.ACCESSOR.DBACCESS.006", "BigDecimal", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public java.util.Date getDate(String columnName) throws DataAccessException {
        try {
            return new java.util.Date(this.resultSet.getDate(columnName).getTime());
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.025", "CB3.ACCESSOR.DBACCESS.006", "Date", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Float getFloat(String columnName) throws DataAccessException {
        try {
            return new Float(this.resultSet.getFloat(columnName));
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.026", "CB3.ACCESSOR.DBACCESS.006", "Float", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Long getLong(String columnName) throws DataAccessException {
        try {
            return new Long(this.resultSet.getLong(columnName));
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.027", "CB3.ACCESSOR.DBACCESS.006", "Long", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Short getShort(String columnName) throws DataAccessException {
        try {
            return new Short(this.resultSet.getShort(columnName));
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.028", "CB3.ACCESSOR.DBACCESS.006", "Short", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws DataAccessException {
        try {
            return this.resultSet.getTimestamp(columnName);
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.029", "CB3.ACCESSOR.DBACCESS.006", "Timestamp", this.sql, stringOfParameter, stringOfRowIndex, columnName), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Map<String, Object> toMap() throws DataAccessException {
        if (this.recordMap != null) {
            return this.recordMap;
        }
        this.recordMap = new HashMap();
        int columns = 0;
        try {
            columns = this.resultSet.getMetaData().getColumnCount();
            int index = 1;
            while (index <= columns) {
                int type = this.resultSet.getMetaData().getColumnType(index);
                Object value = null;
                switch (type) {
                    case 91: {
                        Date date = this.resultSet.getDate(index);
                        if (date == null) break;
                        value = new java.util.Date(date.getTime());
                        break;
                    }
                    case 93: {
                        value = this.resultSet.getTimestamp(index);
                        break;
                    }
                    default: {
                        value = this.resultSet.getObject(index);
                    }
                }
                this.recordMap.put(this.resultSet.getMetaData().getColumnName(index), value);
                ++index;
            }
        }
        catch (SQLException e) {
            String stringOfParameter = this.parameter == null ? "" : this.parameter.toString();
            String stringOfRowIndex = this.row == 0 ? "" : Integer.toString(this.row);
            DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.020", "CB3.ACCESSOR.DBACCESS.005", this.sql, stringOfParameter, stringOfRowIndex), "", e);
            LOG.info((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return this.recordMap;
    }

    @Override
    public Map<String, String> toMapStringValue() throws DataAccessException {
        if (this.recordStringMap != null) {
            return this.recordStringMap;
        }
        this.recordStringMap = new HashMap();
        for (Map.Entry<String, Object> entry : this.toMap().entrySet()) {
            String value = null;
            Object obj = entry.getValue();
            if (obj != null) {
                value = obj instanceof Timestamp ? DateUtil.formatTimestamp((Timestamp)obj) : (obj instanceof java.util.Date ? DateUtil.formatDate((java.util.Date)obj) : obj.toString());
            }
            this.recordStringMap.put(entry.getKey(), value);
        }
        return this.recordStringMap;
    }
}

