/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReaderImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordReaderConfig;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedLineRecordReader
extends FlatFileRecordReaderImpl {
    private static final Log LOG = LogFactory.getLog(DelimitedLineRecordReader.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private DelimitedLineRecordReaderConfig config = null;
    private String ruleFilepath = null;
    private String configFilepath = null;
    private int row = 0;

    @Override
    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.config.setFilepath(filepath);
        super.open(filepath);
    }

    @Override
    public FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException {
        try {
            if (!this.isOpen()) {
                AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.001", "CB3.ACCESSOR.FILEACCESS.001", this.getFilepath()));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
            String nextLine = this.getNextLine();
            return nextLine != null ? this.parseLine(nextLine) : null;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.002", "CB3.ACCESSOR.FILEACCESS.004"), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        this.config = (DelimitedLineRecordReaderConfig)ConfigurationLoader.load(this.getRuleFilepath(), key);
        this.configFilepath = key;
        if (this.config.getSeparator() == null || this.config.getSeparator().length() == 0) {
            this.config.setSeparator(",");
        }
        if (this.config.getEncode() == null || this.config.getEncode().length() == 0) {
            this.config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
        }
        super.setFilepath(this.config.getFilepath());
        super.setEncode(this.config.getEncode());
    }

    private String getNextLine() throws IOException {
        int skipLines = this.config.getSkipLines();
        if (this.row == 0 && skipLines > 0) {
            int i = 0;
            while (i < skipLines) {
                super.getBufferedReader().readLine();
                ++this.row;
                ++i;
            }
        }
        String nextLine = super.getBufferedReader().readLine();
        ++this.row;
        return nextLine;
    }

    private FlatFileRecord parseLine(String nextLine) throws IOException, DataFormatException {
        if (nextLine == null || nextLine.length() == 0) {
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        if (this.config.getQuotechar() != null && this.config.getQuotechar().length() > 0) {
            StringBuffer fieldValue = new StringBuffer();
            char separator = this.config.getSeparator().charAt(0);
            char quotechar = this.config.getQuotechar().charAt(0);
            boolean inQuotes = false;
            do {
                if (inQuotes) {
                    fieldValue.append(System.getProperty("line.separator"));
                    nextLine = this.getNextLine();
                    if (nextLine == null) break;
                }
                int i = 0;
                while (i < nextLine.length()) {
                    char charVal = nextLine.charAt(i);
                    if (charVal == quotechar) {
                        if (inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == quotechar) {
                            fieldValue.append(nextLine.charAt(i + 1));
                            ++i;
                        } else if (i > 2 && nextLine.charAt(i - 1) != separator && nextLine.length() > i + 1 && nextLine.charAt(i + 1) != separator) {
                            fieldValue.append(charVal);
                        } else {
                            inQuotes = !inQuotes;
                        }
                    } else if (charVal == separator && !inQuotes) {
                        tokensOnThisLine.add(fieldValue.toString());
                        fieldValue = new StringBuffer();
                    } else {
                        fieldValue.append(charVal);
                    }
                    ++i;
                }
            } while (inQuotes);
            tokensOnThisLine.add(fieldValue.toString());
        } else {
            String separator = this.config.getSeparator();
            StringTokenizer tokenizer = new StringTokenizer(nextLine, separator);
            while (tokenizer.hasMoreTokens()) {
                tokensOnThisLine.add(tokenizer.nextToken());
            }
        }
        FlatFileRecordImpl record = new FlatFileRecordImpl(this.makeMap(tokensOnThisLine));
        return record;
    }

    private LinkedHashMap<String, String> makeMap(List<String> dataList) throws DataFormatException {
        LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
        DelimitedLineRecordFieldConfig field = null;
        int fieldCnt = this.config.getFieldList().size();
        if (this.config.getFieldList().size() != dataList.size()) {
            DataFormatException e = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.003", "CB3.ACCESSOR.FILEACCESS.010", this.configFilepath, fieldCnt, this.config.getFilepath(), dataList.size()));
            LOG.info((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        int i = 0;
        while (i < fieldCnt) {
            RecordFieldReaderFormatable fieldFormat;
            field = this.config.getFieldList().get(i);
            String data = dataList.get(i);
            if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
                try {
                    fieldFormat = (RecordFieldReaderFormatable)Class.forName(field.getPatternClass()).newInstance();
                    data = fieldFormat.trim(field.getAlign(), field.getPadding(), data);
                    data = fieldFormat.format(field.getPattern(), field.getType(), data);
                }
                catch (DataFormatException e) {
                    throw e;
                }
                catch (Exception e) {
                    DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.004", "CB3.ACCESSOR.FILEACCESS.009", field.getPatternClass()));
                    LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                    throw ex;
                }
            } else {
                fieldFormat = new RecordFieldReaderFormat(this.configFilepath, field.getName());
                data = ((RecordFieldReaderFormat)fieldFormat).trim(field.getAlign(), field.getPadding(), data);
                data = ((RecordFieldReaderFormat)fieldFormat).format(field.getPattern(), field.getType(), data);
            }
            recordMap.put(field.getName(), data);
            ++i;
        }
        return recordMap;
    }

    public String getRuleFilepath() {
        if (this.ruleFilepath == null) {
            this.ruleFilepath = "DelimitedLineRecordReaderRule.xml";
        }
        return this.ruleFilepath;
    }

    public void setRuleFilepath(String path) {
        this.ruleFilepath = path;
    }
}

