/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriterImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.fixed.FixedLengthRecordWriterConfig;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedLengthRecordWriter
extends FlatFileRecordWriterImpl {
    private static final Log LOG = LogFactory.getLog(FixedLengthRecordWriter.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private FixedLengthRecordWriterConfig config = null;
    private String ruleFilepath = null;
    private String configFilepath = null;
    private int row = 0;

    @Override
    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.config.setFilepath(filepath);
        super.open(filepath);
    }

    @Override
    public void write(FlatFileRecord record) throws AccessorNotOpenException, DataFileIOException, DataFormatException {
        if (!this.isOpen()) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.006", "CB3.ACCESSOR.FILEACCESS.001", this.getFilepath()));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        this.writeNext(record);
    }

    @Override
    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        this.config = (FixedLengthRecordWriterConfig)ConfigurationLoader.load(this.getRuleFilepath(), key);
        this.configFilepath = key;
        if (this.config.getAppend() == null || this.config.getAppend().length() == 0) {
            this.config.setAppend("false");
        }
        if (this.config.getEncode() == null || this.config.getEncode().length() == 0) {
            this.config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
        }
        if (this.config.getLineSeparator() == null || this.config.getLineSeparator().length() == 0) {
            this.config.setLineSeparator(RecordFieldConstants.SYSTEM_LINE_SEPARATOR);
        } else {
            this.config.setLineSeparator(this.config.getLineSeparator().replaceAll("\\\\r", "\r"));
            this.config.setLineSeparator(this.config.getLineSeparator().replaceAll("\\\\n", "\n"));
        }
        super.setFilepath(this.config.getFilepath());
        super.setAppend(this.config.getAppend());
        super.setEncode(this.config.getEncode());
    }

    private void writeNext(FlatFileRecord nextLine) throws DataFileIOException, DataFormatException {
        if (nextLine == null) {
            return;
        }
        Map<String, String> fileRecordMap = nextLine.toMap();
        try {
            String recordString = this.makeRecordString(fileRecordMap);
            super.getBufferedWriter().write(recordString);
            super.getBufferedWriter().write(this.config.getLineSeparator());
            super.getBufferedWriter().flush();
            ++this.row;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.007", "CB3.ACCESSOR.FILEACCESS.004", e));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public FlatFileRecord createFlatFileRecord(Map<String, String> record) {
        if (record == null) {
            return null;
        }
        LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
        List<FixedLengthRecordFieldConfig> fieldList = this.config.getFieldList();
        for (FixedLengthRecordFieldConfig field : fieldList) {
            fileRecordMap.put(field.getName(), record.get(field.getName()));
        }
        return new FlatFileRecordImpl(fileRecordMap);
    }

    private String makeRecordString(Map<String, String> fileRecordMap) throws DataFormatException, UnsupportedEncodingException {
        StringBuffer recordString = new StringBuffer();
        List<FixedLengthRecordFieldConfig> fieldList = this.config.getFieldList();
        for (FixedLengthRecordFieldConfig field : fieldList) {
            RecordFieldWriterFormatable fieldFormat;
            DataFormatException ex;
            String value = fileRecordMap.get(field.getName());
            if (field.getLength() == null || field.getLength().length() == 0) {
                ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.008", "CB3.ACCESSOR.FILEACCESS.016", this.configFilepath, field.getName()));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
            if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
                try {
                    fieldFormat = (RecordFieldWriterFormatable)Class.forName(field.getPatternClass()).newInstance();
                    value = fieldFormat.format(field.getPattern(), field.getType(), value);
                    value = fieldFormat.padding(field.getLength(), field.getAlign(), field.getPadding(), value);
                }
                catch (DataFormatException e) {
                    throw e;
                }
                catch (Exception e) {
                    DataFormatException ex2 = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.009", "CB3.ACCESSOR.FILEACCESS.009", field.getPatternClass()));
                    LOG.info((Object)ex2.getMessage(), (Throwable)((Object)ex2));
                    throw ex2;
                }
            } else {
                fieldFormat = new RecordFieldWriterFormat(this.configFilepath, field.getName());
                value = ((RecordFieldWriterFormat)fieldFormat).format(field.getPattern(), field.getType(), value);
                value = ((RecordFieldWriterFormat)fieldFormat).padding(field.getLength(), field.getAlign(), field.getPadding(), value);
            }
            if (value == null || value.getBytes(this.config.getEncode()).length != Integer.parseInt(field.getLength())) {
                ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.FIXED.010", "CB3.ACCESSOR.FILEACCESS.017", this.configFilepath, field.getName(), field.getLength(), fileRecordMap.get(field.getName()), value));
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
            recordString.append(value);
        }
        return recordString.toString();
    }

    public String getRuleFilepath() {
        if (this.ruleFilepath == null) {
            this.ruleFilepath = "FixedLengthRecordWriterRule.xml";
        }
        return this.ruleFilepath;
    }

    public void setRuleFilepath(String path) {
        this.ruleFilepath = path;
    }
}

