/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.container.service;

import jp.co.cybec.cb3.accessor.DataAccessContext;
import jp.co.cybec.cb3.accessor.DataAccessContextLifeCycle;
import jp.co.cybec.cb3.container.service.Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.exception.ServiceExecutionException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

public abstract class CB3Service
implements Service {
    private DataAccessContext dataAccessContext = null;
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public void setDataAccessContext(DataAccessContext dataAccessContext) {
        this.dataAccessContext = dataAccessContext;
    }

    public DataAccessContext getDataAccessContext() {
        return this.dataAccessContext;
    }

    public int callService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {
        try {
            int n = this.doService(serviceParameters, runtimeParameters);
            return n;
        }
        catch (Exception e) {
            throw new ServiceExecutionException(MESSAGE.getErrorMessage("CONTAINER.SERVICE.001", "CB3.CONTAINER.SERVICE.001"), e);
        }
        finally {
            try {
                if (this.dataAccessContext != null) {
                    ((DataAccessContextLifeCycle)((Object)this.getDataAccessContext())).release();
                }
            }
            catch (Exception e) {
                throw new ServiceExecutionException(MESSAGE.getErrorMessage("CONTAINER.SERVICE.002", "CB3.CONTAINER.SERVICE.002"), e);
            }
        }
    }

    protected abstract int doService(ServiceParameters var1, RuntimeParameters var2) throws ServiceException;
}

