/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.util.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.co.cybec.cb3.exception.MessageResourceException;
import jp.co.cybec.cb3.util.logging.LogMessageIdentifier;

public class LogMessageFactory {
    private ResourceBundle bundle = null;
    private String propertyFileName = null;

    public LogMessageFactory(String propertyFileName) throws MessageResourceException {
        try {
            this.bundle = ResourceBundle.getBundle(propertyFileName);
        }
        catch (MissingResourceException e) {
            throw new MessageResourceException("[" + propertyFileName + ".properties]\u304c\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", e);
        }
        this.propertyFileName = propertyFileName;
    }

    public String getMessage(String messageId) {
        try {
            StringBuilder message = new StringBuilder();
            message.append(this.getMessageIdentifier());
            message.append("MessageID:[");
            message.append(messageId);
            message.append("] ");
            message.append(this.bundle.getString(messageId));
            return message.toString();
        }
        catch (MissingResourceException e) {
            return "\u30e1\u30c3\u30bb\u30fc\u30b8ID[" + messageId + "]\u304c[" + this.propertyFileName + ".properties]\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getMessage(String messageId, Object ... args) {
        try {
            message = new StringBuilder();
            message.append(this.getMessageIdentifier());
            message.append("MessageID:[");
            message.append(messageId);
            message.append("] ");
            message.append(this.bundle.getString(messageId));
            return MessageFormat.format(message.toString(), args);
        }
        catch (MissingResourceException e) {
            message = new StringBuilder();
            message.append("\u30e1\u30c3\u30bb\u30fc\u30b8ID[");
            message.append(messageId);
            message.append("]\u304c[");
            message.append(this.propertyFileName);
            message.append(".properties]\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u5f15\u6570\uff1a[");
            var8_6 = args;
            var7_7 = args.length;
            var6_8 = 0;
            ** while (var6_8 < var7_7)
        }
lbl-1000:
        // 1 sources

        {
            arg = var8_6[var6_8];
            message.append(arg);
            message.append(", ");
            ++var6_8;
            continue;
        }
lbl37:
        // 1 sources

        if (message.lastIndexOf(", ") == message.length() - 2) {
            message.delete(message.length() - 2, message.length());
        }
        message.append("]");
        return message.toString();
    }

    public String getErrorMessage(String errorCode, String messageId) {
        try {
            StringBuilder message = new StringBuilder();
            message.append(this.getMessageIdentifier());
            message.append("ErrorCode:[");
            message.append(errorCode);
            message.append("] ");
            message.append("MessageID:[");
            message.append(messageId);
            message.append("] ");
            message.append(this.bundle.getString(messageId));
            return message.toString();
        }
        catch (MissingResourceException e) {
            return "\u30e1\u30c3\u30bb\u30fc\u30b8ID[" + messageId + "]\u304c[" + this.propertyFileName + ".properties]\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getErrorMessage(String errorCode, String messageId, Object ... args) {
        try {
            message = new StringBuilder();
            message.append(this.getMessageIdentifier());
            message.append("ErrorCode:[");
            message.append(errorCode);
            message.append("] ");
            message.append("MessageID:[");
            message.append(messageId);
            message.append("] ");
            message.append(this.bundle.getString(messageId));
            return MessageFormat.format(message.toString(), args);
        }
        catch (MissingResourceException e) {
            message = new StringBuilder();
            message.append("\u30e1\u30c3\u30bb\u30fc\u30b8ID[");
            message.append(messageId);
            message.append("]\u304c[");
            message.append(this.propertyFileName);
            message.append(".properties]\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u5f15\u6570\uff1a[");
            var9_7 = args;
            var8_8 = args.length;
            var7_9 = 0;
            ** while (var7_9 < var8_8)
        }
lbl-1000:
        // 1 sources

        {
            arg = var9_7[var7_9];
            message.append(arg);
            message.append(", ");
            ++var7_9;
            continue;
        }
lbl43:
        // 1 sources

        if (message.lastIndexOf(", ") == message.length() - 2) {
            message.delete(message.length() - 2, message.length());
        }
        message.append("]");
        return message.toString();
    }

    private String getMessageIdentifier() {
        StringBuilder message = new StringBuilder();
        if (LogMessageIdentifier.getJobProcessId() != null) {
            message.append("JobProcessID:[");
            message.append(LogMessageIdentifier.getJobProcessId());
            message.append("] ");
        }
        if (LogMessageIdentifier.getJobId() != null) {
            message.append("JobID:[");
            message.append(LogMessageIdentifier.getJobId());
            message.append("] ");
        }
        if (LogMessageIdentifier.getTaskId() != null) {
            message.append("TaskID:[");
            message.append(LogMessageIdentifier.getTaskId());
            message.append("] ");
        }
        if (LogMessageIdentifier.getServiceId() != null) {
            message.append("ServiceID:[");
            message.append(LogMessageIdentifier.getServiceId());
            message.append("] ");
        }
        return message.toString();
    }
}

