/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriter;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileRecordWriterImpl
implements FlatFileRecordWriter,
AccessorsLifeCycle {
    private static final Log LOG = LogFactory.getLog(FlatFileRecordWriterImpl.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String filepath = null;
    private BufferedWriter writer = null;
    private String encode = null;
    private boolean append = false;
    private boolean isOpen = false;

    @Override
    public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        if (this.isOpen) {
            AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.012", "CB3.ACCESSOR.FILEACCESS.002", this.filepath));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (this.filepath == null || this.filepath.length() == 0) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.017", "CB3.ACCESSOR.FILEACCESS.018"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.filepath), this.append), this.encode));
            this.isOpen = true;
        }
        catch (FileNotFoundException e) {
            DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.013", "CB3.ACCESSOR.FILEACCESS.003", this.filepath), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.014", "CB3.ACCESSOR.FILEACCESS.004", this.filepath), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.filepath = filepath;
        this.open();
    }

    @Override
    public void write(FlatFileRecord record) throws AccessorNotOpenException, DataFileIOException, DataFormatException {
    }

    @Override
    public FlatFileRecord createFlatFileRecord(Map<String, String> record) {
        return null;
    }

    @Override
    public void close() throws DataFileIOException {
        if (this.isOpen) {
            try {
                this.writer.close();
                this.writer = null;
                this.isOpen = false;
            }
            catch (IOException e) {
                DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.015", "CB3.ACCESSOR.FILEACCESS.004", this.filepath), e);
                LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                throw ex;
            }
        }
    }

    @Override
    public void initialize(String key) {
    }

    @Override
    public void release() {
        this.close();
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    protected BufferedWriter getBufferedWriter() {
        return this.writer;
    }

    protected boolean isOpen() {
        return this.isOpen;
    }

    protected boolean getAppend() {
        return this.append;
    }

    protected void setAppend(String append) {
        this.append = append.equalsIgnoreCase("true");
    }

    protected String getEncode() {
        return this.encode;
    }

    protected void setEncode(String encode) {
        this.encode = encode;
    }
}

