/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriterImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordFieldConfig;
import jp.co.cybec.cb3.accessor.fileaccess.flat.delimited.DelimitedLineRecordWriterConfig;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedLineRecordWriter
extends FlatFileRecordWriterImpl {
    private static final Log LOG = LogFactory.getLog(DelimitedLineRecordWriter.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private DelimitedLineRecordWriterConfig config = null;
    private String ruleFilepath = null;
    private String configFilepath = null;
    private int row = 0;

    @Override
    public void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
        this.config.setFilepath(filepath);
        super.open(filepath);
    }

    @Override
    public void write(FlatFileRecord record) throws AccessorNotOpenException, DataFileIOException, DataFormatException {
        if (!this.isOpen()) {
            AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.005", "CB3.ACCESSOR.FILEACCESS.001", this.getFilepath()));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        this.writeNext(record);
    }

    @Override
    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        this.config = (DelimitedLineRecordWriterConfig)ConfigurationLoader.load(this.getRuleFilepath(), key);
        this.configFilepath = key;
        if (this.config.getSeparator() == null || this.config.getSeparator().length() == 0) {
            this.config.setSeparator(",");
        }
        if (this.config.getAppend() == null || this.config.getAppend().length() == 0) {
            this.config.setAppend("false");
        }
        if (this.config.getEncode() == null || this.config.getEncode().length() == 0) {
            this.config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
        }
        if (this.config.getLineSeparator() == null || this.config.getLineSeparator().length() == 0) {
            this.config.setLineSeparator(RecordFieldConstants.SYSTEM_LINE_SEPARATOR);
        } else {
            this.config.setLineSeparator(this.config.getLineSeparator().replaceAll("\\\\r", "\r"));
            this.config.setLineSeparator(this.config.getLineSeparator().replaceAll("\\\\n", "\n"));
        }
        super.setFilepath(this.config.getFilepath());
        super.setAppend(this.config.getAppend());
        super.setEncode(this.config.getEncode());
    }

    private void writeNext(FlatFileRecord nextLine) throws DataFileIOException, DataFormatException {
        if (nextLine == null) {
            return;
        }
        Map<String, String> fileRecordMap = nextLine.toMap();
        try {
            String recordString = this.makeRecordString(fileRecordMap);
            super.getBufferedWriter().write(recordString);
            super.getBufferedWriter().write(this.config.getLineSeparator());
            super.getBufferedWriter().flush();
            ++this.row;
        }
        catch (IOException e) {
            DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.006", "CB3.ACCESSOR.FILEACCESS.004", e));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public FlatFileRecord createFlatFileRecord(Map<String, String> record) {
        if (record == null) {
            return null;
        }
        HashMap<String, String> recordMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : record.entrySet()) {
            recordMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
        List<DelimitedLineRecordFieldConfig> fieldList = this.config.getFieldList();
        for (DelimitedLineRecordFieldConfig field : fieldList) {
            fileRecordMap.put(field.getName(), (String)recordMap.get(field.getName().toUpperCase()));
        }
        return new FlatFileRecordImpl(fileRecordMap);
    }

    private String makeRecordString(Map<String, String> fileRecordMap) throws DataFormatException {
        StringBuffer recordString = new StringBuffer();
        List<DelimitedLineRecordFieldConfig> fieldList = this.config.getFieldList();
        for (DelimitedLineRecordFieldConfig field : fieldList) {
            RecordFieldWriterFormatable fieldFormat;
            String value = fileRecordMap.get(field.getName());
            if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
                try {
                    fieldFormat = (RecordFieldWriterFormatable)Class.forName(field.getPatternClass()).newInstance();
                    value = fieldFormat.format(field.getPattern(), field.getType(), value);
                    value = fieldFormat.padding(field.getLength(), field.getAlign(), field.getPadding(), value);
                }
                catch (DataFormatException e) {
                    throw e;
                }
                catch (Exception e) {
                    DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.FLAT.DELIMITED.007", "CB3.ACCESSOR.FILEACCESS.009", field.getPatternClass()));
                    LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
                    throw ex;
                }
            } else {
                fieldFormat = new RecordFieldWriterFormat(this.configFilepath, field.getName());
                value = ((RecordFieldWriterFormat)fieldFormat).format(field.getPattern(), field.getType(), value);
                value = ((RecordFieldWriterFormat)fieldFormat).padding(field.getLength(), field.getAlign(), field.getPadding(), value);
            }
            if (recordString.length() > 0) {
                recordString.append(this.config.getSeparator());
            }
            if (value == null) continue;
            if (this.config.getQuotechar() != null && this.config.getQuotechar().length() > 0) {
                recordString.append(this.config.getQuotechar()).append(value).append(this.config.getQuotechar());
                continue;
            }
            recordString.append(value);
        }
        return recordString.toString();
    }

    public String getRuleFilepath() {
        if (this.ruleFilepath == null) {
            this.ruleFilepath = "DelimitedLineRecordWriterRule.xml";
        }
        return this.ruleFilepath;
    }

    public void setRuleFilepath(String path) {
        this.ruleFilepath = path;
    }
}

