/*
 * CB3JdbcTemplate.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

/**
 * f[^ANZXNXB
 * @author Lijuan Sun
 */
public class CB3JdbcTemplate {

	/** O */
	private static final Log LOG = LogFactory.getLog(CB3JdbcTemplate.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** SQLp[^̋؂蕶 */
	private static final char[] PARAMETER_SEPARATORS = new char[] { '"', '\'', ':', '&', ',', ';',
			'(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^' };

	/** JdbcTemplate */
	private JdbcTemplate jdbcTemplate = null;

	/** PreparedStatementLbV */
	private Map<String, PreparedStatement> preparedStatementCache = new HashMap<String, PreparedStatement>();

	/** ParsedSqlLbV */
	private Map<String, ParsedSql> parsedSqlCache = new HashMap<String, ParsedSql>();

	/** RlNV */
	private Connection con = null;

	/**
	 * RXgN^B
	 *
	 * @param jdbcTemplate JdbcTemplate
	 */
	public CB3JdbcTemplate(JdbcTemplate jdbcTemplate) {

		this.jdbcTemplate = jdbcTemplate;
	}

	/**
	 * SpringJdbcTemplate擾܂B
	 * @return JdbcTemplate
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/**
	 * ㏈܂B<br>
	 * ێĂResultSetAPreparedStatementׂăN[Y܂B
	 * ܂ARlNV[X܂B
	 */
	public void close() {

		// PreparedStatement̒gN[Y
		for (String key : preparedStatementCache.keySet()) {
			if (preparedStatementCache.get(key) != null) {
				JdbcUtils.closeStatement(preparedStatementCache.get(key));
			}
		}

		// RlNV[X
		if (con != null) {
			DataSourceUtils.releaseConnection(con, getJdbcTemplate().getDataSource());
			con = null;
		}

		// LbVNA
		preparedStatementCache.clear();
	}

	/**
	 * f[^擾郁\bh(p[^tSQL)B
	 *
	 * @param sql SQL
	 * @param parameter p[^
	 * @return ʂResultSet
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	public ResultSet query(String sql, Map<String, Object> parameter) throws DataAccessException {

		// fobOOo
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_012, sql, parameter));
		}

		try {
			// RlNV擾
			con = getConnection();

			// PreparedStatement擾
			PreparedStatement ps = getPreparedStatement(sql, parameter);

			// SQLs
			ResultSet rs = ps.executeQuery();

			// fobOOo
			if (LOG.isDebugEnabled()) {
				LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_013));
			}

			// ʂ߂
			return rs;

		} catch (SQLException e) {
			// ObZ[W쐬
			Object[] msg = { sql, parameter };
			DataAccessException ex = jdbcTemplate.getExceptionTranslator().translate(
					MESSAGE.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_001,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_001, msg), sql, e);
			// Oo
			LOG.info(ex.getMessage(), ex);
			// DataAccessExceptionX[
			throw ex;
		}

	}

	/**
	 *
	 * f[^擾郁\bh(p[^tȂSQL)B
	 *
	 * @param sql SQL
	 * @return ʂResultSet
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	public ResultSet query(String sql) throws DataAccessException {

		// fobOOo
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_012, sql, ""));
		}

		try {
			// RlNV擾
			con = getConnection();

			// PreparedStatement擾
			PreparedStatement ps = getPreparedStatement(sql, null);

			// SQLs
			ResultSet rs = ps.executeQuery();

			// fobOOo
			if (LOG.isDebugEnabled()) {
				LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_013));
			}

			// ʂ߂
			return rs;

		} catch (SQLException e) {
			// ObZ[W쐬
			Object[] msg = { sql, "" };
			DataAccessException ex = jdbcTemplate.getExceptionTranslator().translate(
					MESSAGE.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_002,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_001, msg), sql, e);
			// Oo
			LOG.info(ex.getMessage(), ex);
			// DataAccessExceptionX[
			throw ex;
		}
	}

	/**
	 *
	 * f[^XV郁\bh(p[^tSQL)B
	 *
	 * @param sql SQL
	 * @param parameter p[^
	 * @return 
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	public int update(String sql, Map<String, Object> parameter) throws DataAccessException {

		// fobOOo
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_012, sql, parameter));
		}

		try {
			// RlNV擾
			con = getConnection();

			// PreparedStatement擾
			PreparedStatement ps = getPreparedStatement(sql, parameter);

			// SQLs
			int recordNumber = ps.executeUpdate();

			// fobOOo
			if (LOG.isDebugEnabled()) {
				LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_014, recordNumber));
			}

			return recordNumber;

		} catch (SQLException e) {
			// ObZ[W쐬
			Object[] msg = { sql, parameter };
			DataAccessException ex = jdbcTemplate.getExceptionTranslator().translate(
					MESSAGE.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_003,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_001, msg), sql, e);
			// Oo
			LOG.info(ex.getMessage(), ex);
			// DataAccessExceptionX[
			throw ex;
		}
	}

	/**
	 *
	 * f[^XV郁\bh(p[^tȂSQL)B
	 *
	 * @param sql SQL
	 * @return 
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	public int update(String sql) throws DataAccessException {

		// fobOOo
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_012, sql, ""));
		}

		try {
			// RlNV擾
			con = getConnection();

			// PreparedStatement擾
			PreparedStatement ps = getPreparedStatement(sql, null);

			// SQLs
			int recordNumber = ps.executeUpdate();

			// fobOOo
			if (LOG.isDebugEnabled()) {
				LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_014, recordNumber));
			}

			return recordNumber;

		} catch (SQLException e) {
			// ObZ[W쐬
			Object[] msg = { sql, "" };
			DataAccessException ex = jdbcTemplate.getExceptionTranslator().translate(
					MESSAGE.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_004,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_001, msg), sql, e);
			// Oo
			LOG.info(ex.getMessage(), ex);
			// DataAccessExceptionX[
			throw ex;
		}
	}

	/**
	 * R~bg
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇA
	 * 		auto-commit[hłꍇB
	 */
	public void commit() throws DataAccessException {

		try {
			// RlNV擾
			con = getConnection();

			// R~bg
			con.commit();
		} catch (SQLException e) {
			// ObZ[W쐬
			DataAccessException ex = jdbcTemplate.getExceptionTranslator().translate(
					MESSAGE.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_005,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_002), "", e);
			// Oo
			LOG.info(ex.getMessage(), ex);
			// DataAccessExceptionX[
			throw ex;
		}
	}

	/**
	 * RlNV擾B
	 * @return RlNV
	 */
	private Connection getConnection() {

		// RlNV擾
		if (con == null) {
			con = DataSourceUtils.getConnection(getJdbcTemplate().getDataSource());
		}
		return con;
	}

	/**
	 * PreparedStatement擾܂B
	 *
	 * @param sql SQL
	 * @param parameter SQL̃p[^
	 * @return PreparedStatement
	 * @throws SQLException 炩̃f[^x[XANZXG[ꍇB
	 */
	private PreparedStatement getPreparedStatement(String sql, Map<String, Object> parameter)
			throws SQLException {

		// ͍ς݂SQL擾܂B
		ParsedSql parsedSql = parsedSqlCache.get(sql);
		if (parsedSql == null) {
			// ͍ς݂SQLȂꍇ͉͂s܂B
			parsedSql = parseSql(sql);
			parsedSqlCache.put(sql, parsedSql);
		}

		// PreparedStatement擾܂B
		PreparedStatement ps = preparedStatementCache.get(sql);
		if (ps == null) {
			// PreparedStatement쐬
			ps = con.prepareStatement(parsedSql.getSql());

			// Mapɒǉ
			preparedStatementCache.put(sql, ps);
		}

		// OsƂ̃p[^NA܂B
		ps.clearParameters();

		// p[^ȂꍇPreparedStatementԂ܂B
		if (parameter == null || parameter.size() == 0) {
			return ps;
		}

		// p[^̒lPreparedStatementɐݒ肵܂B
		parsedSql.getParameterNames();
		List<Object> paramValues = new ArrayList<Object>();
		int paramIndex = 1;
		for (String paramName : parsedSql.getParameterNames()) {
			Object value = parameter.get(paramName);
			ps.setObject(paramIndex, value);
			// Oo͂̂߃XgɊi[B
			paramValues.add(value);
			paramIndex++;
		}

		// fobOOo
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_007, parsedSql.getSql(), paramValues));
		}

		return ps;
	}

	/**
	 * SQL͂܂B
	 *
	 * @param sql ͑OSQL
	 * @return ͌SQLێParsedSql
	 */
	private ParsedSql parseSql(String sql) {

		ParsedSql parsedSql = new ParsedSql();

		char[] originalSql = sql.toCharArray();
		boolean withinQuotes = false;
		char currentQuote = '-';

		StringBuilder compiledSql = new StringBuilder();

		int i = 0;
		while (i < originalSql.length) {
			char c = originalSql[i];
			if (withinQuotes) {
				compiledSql.append(c);
				if (c == currentQuote) {
					withinQuotes = false;
					currentQuote = '-';
				}
			} else {
				if (c == '"' || c == '\'') {
					compiledSql.append(c);
					withinQuotes = true;
					currentQuote = c;
				} else {
					if (c == ':' || c == '&') {
						int j = i + 1;
						if (j < originalSql.length && originalSql[j] == ':' && c == ':') {
							i = i + 2;
							continue;
						}
						while (j < originalSql.length && !isParameterSeparator(originalSql[j])) {
							j++;
						}
						if (j - i > 1) {
							String parameter = sql.substring(i + 1, j);
							parsedSql.addParameterNames(parameter);
							compiledSql.append('?');
						}
						i = j - 1;
					} else {
						compiledSql.append(c);
					}
				}
			}
			i++;
		}

		parsedSql.setSql(compiledSql.toString());

		return parsedSql;

	}

	/**
	 * p[^̋؂𔻒肵܂B
	 *
	 * @param c SQL̕
	 * @return p[^̋؂̏ꍇtrueAȊOfalse
	 */
	private boolean isParameterSeparator(char c) {
		if (Character.isWhitespace(c)) {
			return true;
		}
		for (int i = 0; i < PARAMETER_SEPARATORS.length; i++) {
			if (c == PARAMETER_SEPARATORS[i]) {
				return true;
			}
		}
		return false;
	}

}
