/*
 * FlatFileRecordReaderImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * t@C̃R[hǂݍ݃NXB
 * @author Jianming Guo
 */
public class FlatFileRecordReaderImpl implements FlatFileRecordReader, AccessorsLifeCycle {
	/** O */
	private static final Log LOG = LogFactory.getLog(FlatFileRecordReaderImpl.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** t@CpX */
	private String filepath = null;

	/** obt@[[_[ */
	private BufferedReader reader = null;

	/** t@C̃I[vԂێtO */
	private boolean isOpen = false;

	/** GR[h */
	private String encode = null;

	/**
	 * t@CI[v܂B
	 *
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
		// łopenĂꍇAOX[܂B
		if (isOpen) {
			AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_008,
							LogMessageConstant.CB3_ACCESSOR_FILEACCESS_002, filepath));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// t@CpXݒ肳ĂȂꍇ͗OX[܂B
		if (filepath == null || filepath.length() == 0) {
			DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_016,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_018));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// t@C̃I[v
		try {
			reader = new BufferedReader(
					new InputStreamReader(new FileInputStream(new File(filepath)), encode));
			isOpen = true;
		} catch (FileNotFoundException e) {
			DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_009,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_003, filepath), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		} catch (IOException e) {
			DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_010,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, filepath), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	public void open(String filepath) throws AccessorAlreadyOpenedException,
			DataFileNotFoundException, DataFileIOException {
		this.filepath = filepath;
		open();
	}

	/**
	 * ̃R[hԋp܂
	 *
	 * @return ̃R[h
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	public FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException  {
		// qNXŎ
		return null;
	}

	/**
	 * t@CN[Y܂B
	 *
	 * @throws DataFileIOException t@C̃N[YɎsꍇɔ܂B
	 */
	public void close() throws DataFileIOException {
		if (isOpen) {
			// t@C̃N[Y
			try {
				reader.close();
				reader = null;
				isOpen = false;
			} catch (IOException e) {
				DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_011,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, filepath), e);
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}
		}
	}

	/**
	 * ݒt@Cǂݍ݂܂B
	 *
	 * @param key ݒt@C
	 */
	public void initialize(String key) {
		// qNXŎ
	}

	/**
	 * ㏈܂B
	 */
	public void release() {
		close();
	}

	/**
	 * t@CpXԂ܂B
	 *
	 * @return t@CpX
	 */
	protected String getFilepath() {
		return filepath;
	}

	/**
	 * t@CpXݒ肵܂B
	 *
	 * @param filepath t@CpX
	 */
	protected void setFilepath(String filepath) {
		this.filepath = filepath;
	}

	/**
	 * obt@[[_[Ԃ܂B
	 *
	 * @return obt@[[_[
	 */
	protected BufferedReader getBufferedReader() {
		return reader;
	}

	/**
	 * t@C̃I[vԂԂ܂B
	 *
	 * @return t@C̃I[v
	 */
	protected boolean isOpen() {
		return isOpen;
	}

	/**
	 * GR[hԂ܂B
	 *
	 * @return GR[h
	 */
	protected String getEncode() {
		return encode;
	}

	/**
	 * GR[hݒ肵܂B
	 *
	 * @param encode GR[h
	 */
	protected void setEncode(String encode) {
		this.encode = encode;
	}
}
