/*
 * FlatFileRecordWriter.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.util.Map;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;


/**
 * t@C̃R[hނ߂̃C^tF[XB
 * @author Jianming Guo
 */
public interface FlatFileRecordWriter extends Accessor {

	/**
	 * t@CI[v܂B
	 *
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException;

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException;

	/**
	 * t@CɂPs̃R[h݂܂B
	 *
	 * @param record 1s̃R[h
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException R[h̏ݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	void write(FlatFileRecord record) throws AccessorNotOpenException, DataFileIOException, DataFormatException;

	/**
	 * FlatFileRecordf[^쐬܂B
	 *
	 * @param record f[^}bv
	 * @return 쐬FlatFileRecordf[^
	 */
	FlatFileRecord createFlatFileRecord(Map<String, String> record);

	/**
	 * t@CN[Y܂B
	 *
	 * @throws DataFileIOException t@C̃N[YɎsꍇɔ܂B
	 */
	void close() throws DataFileIOException;

}
