/*
 * DelimitedLineRecordReader.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.delimited;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;

import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReaderImpl;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * ϒt@C̃R[hǂݍ݃NXB
 * @author Jianming Guo
 */
public class DelimitedLineRecordReader extends FlatFileRecordReaderImpl {
	/** O */
	private static final Log LOG = LogFactory.getLog(DelimitedLineRecordReader.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** RtBOFݒt@C */
	private DelimitedLineRecordReaderConfig config = null;

	/** [t@CpX */
	private String ruleFilepath = null;

	/** ݒt@CpX */
	private String configFilepath = null;

	/** sԍ */
	private int row = 0;

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	@Override
	public void open(String filepath) throws AccessorAlreadyOpenedException,
			DataFileNotFoundException, DataFileIOException {
		config.setFilepath(filepath);
		super.open(filepath);
	}

	/**
	 * ̃R[hԋp܂B
	 *
	 * @return ̃R[hB݂Ȃꍇ́AnullԂB
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException R[h̓ǂݍݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	public FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException {

		try {
			// t@CI[vĂȂꍇAOX[܂B
			if (!isOpen()) {
				AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_DELIMITED_001,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_001, getFilepath()));
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}

			// t@CPsf[^ǂݍ
			String nextLine = getNextLine();

			// PR[h̃f[^tH[}bgāAFlatFileRecordԋp
			return nextLine != null ? parseLine(nextLine) : null;

		} catch (IOException e) {
			DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_DELIMITED_002,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ϒt@C̐ݒt@Cǂݍ݂܂B
	 *
	 * @param key String ݒt@C
	 * @throws ConfigFileNotFoundException ݒt@C݂Ȃꍇɔ܂B
	 * @throws ConfigFileDefinitionException ݒt@C̊ԈႢɂ蔭܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 */
	public void initialize(String key) throws ConfigFileNotFoundException,
		ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {

		// ϒt@Cݒt@Cǂݍ
		config = (DelimitedLineRecordReaderConfig) ConfigurationLoader.load(
				getRuleFilepath(), key);

		// ݒt@CpX̐ݒ
		this.configFilepath = key;

		// separator̃ftHglݒ
		if (config.getSeparator() == null || config.getSeparator().length() == 0) {
			config.setSeparator(RecordFieldConstants.SEPARATOR_DEFAULT);
		}
		// encodẽftHglݒ
		if (config.getEncode() == null || config.getEncode().length() == 0) {
			config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
		}

		// t@CpXݒ
		super.setFilepath(config.getFilepath());
		// GR[hݒ
		super.setEncode(config.getEncode());
	}

	/**
	 * t@CPsf[^ǂݍ݂܂B
	 *
	 * @return ǂݍ񂾃f[^B
	 * @throws IOException R[h̓ǂݍ݂Ɏsꍇɔ܂B
	 */
	private String getNextLine() throws IOException {

		// XLbvs
		int skipLines = config.getSkipLines();

		if (row == 0 && skipLines > 0) {
		// ړǂݍ and XLbvsݒ肳ꂽꍇ
			for (int i = 0; i < skipLines; i++) {
				// XLbv
				super.getBufferedReader().readLine();
				// sJEg
				row ++;
			}
		}
		// Psf[^ǂݍ
		String nextLine = super.getBufferedReader().readLine();
		// sJEg
		row++;

		return nextLine;
	}

	/**
	 * Psf[^FlatFileRecordɕϊ܂B
	 *
	 * @param nextLine Psf[^̕
	 * @return ϊFlatFileRecord^R[h
	 * @throws IOException R[h̓ǂݍݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	private FlatFileRecord parseLine(String nextLine) throws IOException, DataFormatException {

		if (nextLine == null || nextLine.length() == 0) {
			return null;
		}

		// tB[hXg
		List<String> tokensOnThisLine = new ArrayList<String>();

		if (config.getQuotechar() != null && config.getQuotechar().length() > 0) {
		// NH[gݒ肳ꂽꍇ

			StringBuffer fieldValue = new StringBuffer();

			// Zp[^
			char separator = config.getSeparator().charAt(0);
			// NH[g
			char quotechar = config.getQuotechar().charAt(0);

			// NH[gtOF
			// ڂ̃NH[gꍇinQuotes = true
			boolean inQuotes = false;

			do {
				if (inQuotes) {
					// ڂ̃NH[gAڂ̃NH[g̍sɂȂꍇ
					// PR[hsɂȂꍇ
					fieldValue.append(System.getProperty("line.separator"));
					nextLine = getNextLine();
					if (nextLine == null) {
						break;
					}
				}
				// 1sf[^̕P擾A肵āAtB[hlXg쐬
				for (int i = 0; i < nextLine.length(); i++) {
					// ꕶ擾
					char charVal = nextLine.charAt(i);
					if (charVal == quotechar) {
					// NH[g̏ꍇ
						if (inQuotes && nextLine.length() > (i+1) && nextLine.charAt(i+1) == quotechar) {
							// ڂ̃NH[g and ̕NH[g̏ꍇ(F[,"ab""ccc",])A
							// NH[gPtB[h̒lɐݒ肷
							fieldValue.append(nextLine.charAt(i+1));
							i++;
						} else {
							if (i > 2 && nextLine.charAt(i-1) != separator
									&& nextLine.length() > (i+1) && nextLine.charAt(i+1) != separator) {
								// NH[gO̕ƌ̕separatorȂꍇ(F[,"ab"def",])A
								// NH[gPtB[h̒lɐݒ肷
								fieldValue.append(charVal);
							} else {
								// ڂ̃NH[g̏ꍇFinQuotes = true
								// ڂ̃NH[g̏ꍇFinQuotes = false
								inQuotes = !inQuotes;
							}
						}
					} else if (charVal == separator && !inQuotes) {
						// Zp[^ and inQuotesfalsȅꍇA
						// ̃tB[hl̎擾AXgɒǉ

						// tB[hڂXgɒǉB
						tokensOnThisLine.add(fieldValue.toString());
						fieldValue = new StringBuffer();
					} else {
						// PtB[h̒lݒ肷B
						fieldValue.append(charVal);
					}
				}
			} while (inQuotes);

			// Ō̒lXgɒǉ
			tokensOnThisLine.add(fieldValue.toString());

		} else {
		// NH[gݒ肳Ȃꍇ
			// Zp[^
			String separator = config.getSeparator();

			// ̃g[N쐬
			StringTokenizer tokenizer = new StringTokenizer(nextLine, separator);
			// f[^XgɃZbg
			while (tokenizer.hasMoreTokens()) {
				tokensOnThisLine.add(tokenizer.nextToken());
			}
		}

		// PR[h쐬
		FlatFileRecord record = new FlatFileRecordImpl(makeMap(tokensOnThisLine));

		return record;
	}

	/**
	 * tB[hƃtB[hlXg背R[hMap쐬܂B
	 *
	 * @param dataList tB[hlXg
	 * @return 쐬}bv
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	private LinkedHashMap<String,String> makeMap(List<String> dataList) throws DataFormatException {
		// R[h}bvɃCX^X
		LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
		// tB[h`
		DelimitedLineRecordFieldConfig field = null;
		// tB[h
		int fieldCnt = config.getFieldList().size();

		// ݒt@C̃tB[hƃf[^t@C̃tB[h̃`FbN
		if ( config.getFieldList().size() != dataList.size()){
			DataFormatException e = new DataFormatException(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_DELIMITED_003,
							LogMessageConstant.CB3_ACCESSOR_FILEACCESS_010,
							configFilepath,
							fieldCnt,
							config.getFilepath(),
							dataList.size()));
			LOG.info(e.getMessage(), e);
			throw e;
		}

		// R[h̃tB[hPtH[}bg
		for (int i = 0; i < fieldCnt; i++){
			// tB[h`擾
			field = config.getFieldList().get(i);

			// tB[hl
			String data = dataList.get(i);

			if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
			// p^[NXݒ肳ꂽꍇ
				try {
					// [U[`NXCX^X
					RecordFieldReaderFormatable fieldFormat = (RecordFieldReaderFormatable) Class.forName(field.getPatternClass()).newInstance();

					// pfBO菜
					data = fieldFormat.trim(field.getAlign(), field.getPadding(), data);
					// tH[}bg
					data = fieldFormat.format(field.getPattern(), field.getType(), data);

				} catch (DataFormatException e) {
					throw e;
				} catch (Exception e) {
					DataFormatException ex = new DataFormatException(MESSAGE
							.getErrorMessage(
									ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_DELIMITED_004,
									LogMessageConstant.CB3_ACCESSOR_FILEACCESS_009, field
											.getPatternClass()));
					LOG.info(ex.getMessage(), ex);
					throw ex;
				}
			} else {
			// p^[NXݒ肳Ȃꍇ
				// RecordFieldReaderFormatCX^X
				RecordFieldReaderFormat fieldFormat = new RecordFieldReaderFormat(configFilepath, field.getName());

				// pfBO菜
				data = fieldFormat.trim(field.getAlign(), field.getPadding(), data);

				// tH[}bg
				data = fieldFormat.format(field.getPattern(), field.getType(), data);
			}
			recordMap.put(field.getName(), data);
		}

		return recordMap;
	}

	/**
	 * [t@CpXԂ܂B<br>
	 * @return [t@CpX
	 */
	public String getRuleFilepath() {
		if (ruleFilepath == null) {
			ruleFilepath = RecordFieldConstants.DELIMITED_LINE_FILE_READER_RULE_FILE_NAME;
		}
		return ruleFilepath;
	}

	/**
	 * [t@CpXݒ肵܂B<br>
	 * [t@CpXݒ肵ȂꍇAnullݒ肵ꍇ̓ftHg̃pX
	 * ({@link RecordFieldConstants#DELIMITED_LINE_FILE_READER_RULE_FILE_NAME})gp܂B
	 * @param path [t@CpX
	 */
	public void setRuleFilepath(String path) {
		ruleFilepath = path;
	}
}
