/*
 * FixedLengthRecordReader.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;

import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReaderImpl;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Œ蒷t@C̃R[hǂݍ݃NXB
 * @author Jianming Guo
 */
public class FixedLengthRecordReader extends FlatFileRecordReaderImpl {
	/** O */
	private static final Log LOG = LogFactory.getLog(FixedLengthRecordReader.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** RtBOFݒt@C */
	private FixedLengthRecordReaderConfig config = null;

	/** [t@CpX */
	private String ruleFilepath = null;

	/** ݒt@CpX */
	private String configFilepath = null;

	/** sԍ */
	private int row = 0;

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	@Override
	public void open(String filepath) throws AccessorAlreadyOpenedException,
			DataFileNotFoundException, DataFileIOException {
		config.setFilepath(filepath);
		super.open(filepath);
	}

	/**
	 * ̃R[hԋp܂B
	 *
	 * @return ̃R[hB݂Ȃꍇ́AnullԂB
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException R[h̓ǂݍݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	public FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException{

		try {
			// t@CI[vĂȂꍇAOX[܂B
			if (!isOpen()) {
				AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_001,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_001, getFilepath()));
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}

			// t@CPsf[^ǂݍ
			String nextLine = super.getBufferedReader().readLine();

			// sJEg
			row++;

			// PR[h̃f[^tH[}bgāAFlatFileRecordԋp
			return nextLine != null ? parseLine(nextLine) : null;

		} catch (IOException e) {
			DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_002,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * Œ蒷t@C̐ݒt@Cǂݍ݂܂B
	 *
	 * @param key String ݒt@C
	 * @throws ConfigFileNotFoundException ݒt@C݂Ȃꍇɔ܂B
	 * @throws ConfigFileDefinitionException ݒt@C̊ԈႢɂ蔭܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 */
	public void initialize(String key) throws ConfigFileNotFoundException,
		ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {

		// keyŒ蒷t@Cݒt@Cǂݍ
		config = (FixedLengthRecordReaderConfig) ConfigurationLoader.load(
				getRuleFilepath(), key);

		// ݒt@CpXݒ
		this.configFilepath = key;

		// encodẽftHglݒ
		if (config.getEncode() == null || config.getEncode().length() == 0) {
			config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
		}

		// t@CpXݒ
		super.setFilepath(config.getFilepath());
		// GR[hݒ
		super.setEncode(config.getEncode());
	}

	/**
	 * PR[h̃f[^FlatFileRecordɕϊ܂B
	 *
	 * @param nextLine Ps̃f[^
	 * @return ϊFlatFileRecord^R[h
	 * @throws IOException GR[hȂꍇɔ܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	private FlatFileRecord parseLine(String nextLine) throws IOException, DataFormatException {

		if (nextLine == null || nextLine.length() == 0) {
			return null;
		}

		// R[h}bvCX^X
		LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();

		// Psf[^̕  oCgzɊi[
		byte[] byteNextLine = nextLine.getBytes(config.getEncode());

		// ݒt@C̃tB[h񃊃Xg擾
		List<FixedLengthRecordFieldConfig> fieldList = config.getFieldList();

		// 擪oCg̃CfbNX
		int offset = 0;

		// t@CR[h}bṽf[^쐬
		for (FixedLengthRecordFieldConfig field : fieldList) {
			// oCg
			int length = Integer.parseInt(field.getLength());

			// tB[h̒l擾
			String value = null;
			try {
				value = new String(byteNextLine, offset, length, config.getEncode());
				offset = offset + length;
			} catch (IndexOutOfBoundsException e) {
				// oCgz͈̔͊Ȍꍇ(Psf[^̃oCg < ݒt@C̃oCg̍v)
				DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_003,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_015, configFilepath, config
								.getFilepath()));
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}

			// tH[}bg
			if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
			// p^[NXݒ肳ꂽꍇ
				try {
					// [U[`NXCX^X
					RecordFieldReaderFormatable fieldFormat = (RecordFieldReaderFormatable) Class.forName(field.getPatternClass()).newInstance();

					// pfBO菜
					value = fieldFormat.trim(field.getAlign(), field.getPadding(), value);

					// tH[}bg
					value = fieldFormat.format(field.getPattern(), field.getType(), value);

				} catch (DataFormatException e) {
					throw e;
				} catch (Exception e) {
					DataFormatException ex = new DataFormatException(MESSAGE
							.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_004,
									LogMessageConstant.CB3_ACCESSOR_FILEACCESS_009, field
											.getPatternClass()));
					LOG.info(ex.getMessage(), ex);
					throw ex;
				}
			} else {
			// p^[NXݒ肳Ȃꍇ
				// RecordFieldReaderFormatCX^X
				RecordFieldReaderFormat fieldFormat = new RecordFieldReaderFormat(configFilepath, field.getName());

				// pfBO菜
				value = fieldFormat.trim(field.getAlign(), field.getPadding(), value);

				// tH[}bg
				value = fieldFormat.format(field.getPattern(), field.getType(), value);
			}

			// R[h}bvɃZbg
			recordMap.put(field.getName(), value);
		}

		// oCg`FbN
		if (offset != byteNextLine.length) {
			// Psf[^̃oCg <> ݒt@C̃oCgv̏ꍇ
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_005,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_015, configFilepath, config
							.getFilepath()));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		return new FlatFileRecordImpl(recordMap);
	}

	/**
	 * [t@CpXԂ܂B<br>
	 * @return [t@CpX
	 */
	public String getRuleFilepath() {
		if (ruleFilepath == null) {
			ruleFilepath = RecordFieldConstants.FIXED_LENGTH_FILE_READER_RULE_FILE_NAME;
		}
		return ruleFilepath;
	}

	/**
	 * [t@CpXݒ肵܂B<br>
	 * [t@CpXݒ肵ȂꍇAnullݒ肵ꍇ̓ftHg̃pX
	 * ({@link RecordFieldConstants#FIXED_LENGTH_FILE_READER_RULE_FILE_NAME})gp܂B
	 * @param path [t@CpX
	 */
	public void setRuleFilepath(String path) {
		ruleFilepath = path;
	}
}
