/*
 * FixedLengthRecordWriter.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat.fixed;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormat;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormatable;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordImpl;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriterImpl;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Œ蒷t@C̃R[h݃NXB
 * @author Jianming Guo
 */
public class FixedLengthRecordWriter extends FlatFileRecordWriterImpl {
	/** O */
	private static final Log LOG = LogFactory.getLog(FixedLengthRecordWriter.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** RtBOFݒt@C */
	private FixedLengthRecordWriterConfig config = null;

	/** [t@CpX */
	private String ruleFilepath = null;

	/** ݒt@CpX */
	private String configFilepath = null;

	/** sԍ */
	private int row = 0;

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	@Override
	public void open(String filepath) throws AccessorAlreadyOpenedException,
			DataFileNotFoundException, DataFileIOException {
		config.setFilepath(filepath);
		super.open(filepath);
	}

	/**
	 * 1sR[ht@Cɏ݂܂B
	 *
	 * @param record 1sR[h
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException R[h̏ݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	public void write(FlatFileRecord record) throws AccessorNotOpenException, DataFileIOException,  DataFormatException {
		// t@CI[vĂȂꍇAOX[܂B
		if (!isOpen()) {
			AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_006,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_001, getFilepath()));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// 1sR[ht@Cɏ݂܂B
		writeNext(record);
	}

	/**
	 * ϒt@C̐ݒt@Cǂݍ݂܂B
	 *
	 * @param key String ݒt@C
	 * @throws ConfigFileNotFoundException ݒt@C݂Ȃꍇɔ܂B
	 * @throws ConfigFileDefinitionException ݒt@C̊ԈႢɂ蔭܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 */
	public void initialize(String key) throws ConfigFileNotFoundException,
		ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {

		// keyϒt@Cݒt@Cǂݍ
		config = (FixedLengthRecordWriterConfig) ConfigurationLoader.load(
				getRuleFilepath(), key);

		// ݒt@CpX̐ݒ
		this.configFilepath = key;

		// append̃ftHglݒ
		if (config.getAppend() == null || config.getAppend().length() == 0) {
			config.setAppend(RecordFieldConstants.FILE_OPEN_APPEND_FALSE);
		}
		// encodẽftHglݒ
		if (config.getEncode() == null || config.getEncode().length() == 0) {
			config.setEncode(RecordFieldConstants.SYSTEM_ENCODE);
		}
		// lineSeparator̃ftHglݒ
		if (config.getLineSeparator() == null || config.getLineSeparator().length() == 0) {
			config.setLineSeparator(RecordFieldConstants.SYSTEM_LINE_SEPARATOR);
		} else {
			config.setLineSeparator(config.getLineSeparator().replaceAll("\\\\r", "\r"));
			config.setLineSeparator(config.getLineSeparator().replaceAll("\\\\n", "\n"));
		}

		// t@CpXݒ
		super.setFilepath(config.getFilepath());
		// t@CI[v[hݒ
		super.setAppend(config.getAppend());
		// GR[hݒ
		super.setEncode(config.getEncode());
	}

	/**
	 * 1sR[ht@Cɏ݂܂B
	 *
	 * @param nextLine 1sR[h
	 * @throws DataFileIOException R[h̓ǂݍݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	private void writeNext(FlatFileRecord nextLine) throws DataFileIOException, DataFormatException {
		if (nextLine == null) {
			return;
		}
		// R[h}bvZbg
		Map<String, String> fileRecordMap = nextLine.toMap();

		try {
			// R[h쐬
			String recordString = makeRecordString(fileRecordMap);

			// R[ht@Cɏ
			super.getBufferedWriter().write(recordString);
			// s
			super.getBufferedWriter().write(config.getLineSeparator());

			// Xg[tbV
			super.getBufferedWriter().flush();

			// sJEg
			row++;

		} catch (IOException e) {
			DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_007,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, e));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * FlatFileRecordf[^쐬܂B
	 *
	 * @param record f[^}bv
	 * @return 쐬FlatFileRecordf[^
	 */
	public FlatFileRecord createFlatFileRecord(Map<String, String> record) {

		if (record == null) {
			return null;
		}

		// record̃}bvL[啶ɕϊāAV}bv쐬
		Map<String, String> recordMap = new HashMap<String, String>();
		for (Map.Entry<String, String> entry : record.entrySet()) {
			recordMap.put(entry.getKey().toUpperCase(), entry.getValue());
		}

		// t@CR[h}bvCX^X
		LinkedHashMap<String, String> fileRecordMap = new LinkedHashMap<String, String>();
		// ݒt@C̃tB[h񃊃Xg擾
		List<FixedLengthRecordFieldConfig> fieldList = config.getFieldList();
		// t@CR[h}bṽf[^쐬
		for (FixedLengthRecordFieldConfig field : fieldList) {
			fileRecordMap.put(field.getName(), recordMap.get(field.getName().toUpperCase()));
		}

		return new FlatFileRecordImpl(fileRecordMap);
	}

	/**
	 * tB[hltH[}bgAݗp̃R[h쐬܂B
	 *
	 * @param fileRecordMap R[h}bv
	 * @return 쐬R[h
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 * @throws UnsupportedEncodingException ̃GR[fBOT|[gĂȂꍇɔ܂B
	 */
	private String makeRecordString(Map<String, String> fileRecordMap) throws DataFormatException, UnsupportedEncodingException {
		StringBuffer recordString = new StringBuffer();

		// ݒt@C̃tB[h񃊃Xg擾
		List<FixedLengthRecordFieldConfig> fieldList = config.getFieldList();

		// t@CR[h}bṽf[^쐬
		for (FixedLengthRecordFieldConfig field : fieldList) {
			// tB[hl擾
			String value = fileRecordMap.get(field.getName());

			// oCg̐ݒ肪Ȃꍇ
			if (field.getLength() == null || field.getLength().length() == 0) {
				DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_008,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_016, configFilepath, field
								.getName()));
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}

			// tB[hltH[}bg
			if (field.getPatternClass() != null && field.getPatternClass().length() > 0) {
			// p^[NXݒ肳ꂽꍇ
				try {
					// [U[`NXCX^X
					RecordFieldWriterFormatable fieldFormat = (RecordFieldWriterFormatable) Class.forName(field.getPatternClass()).newInstance();

					// tH[}bg
					value = fieldFormat.format(field.getPattern(), field.getType(), value);

					// pfBO
					value = fieldFormat.padding(field.getLength(), field.getAlign(), field.getPadding(), value);

				} catch (DataFormatException e) {
					throw e;
				} catch (Exception e) {
					DataFormatException ex = new DataFormatException(MESSAGE
							.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_009,
									LogMessageConstant.CB3_ACCESSOR_FILEACCESS_009, field
											.getPatternClass()));
					LOG.info(ex.getMessage(), ex);
					throw ex;
				}
			} else {
			// p^[NXݒ肳Ȃꍇ
				// RecordFieldReaderFormatCX^X
				RecordFieldWriterFormat fieldFormat = new RecordFieldWriterFormat(configFilepath, field.getName());

				// tH[}bg
				value = fieldFormat.format(field.getPattern(), field.getType(), value);

				// pfBO
				value = fieldFormat.padding(field.getLength(), field.getAlign(), field.getPadding(), value);
			}

			// tH[}bgtB[hl`FbN
			if (value == null || value.getBytes(config.getEncode()).length != Integer.parseInt(field.getLength())) {
				DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_FIXED_010,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_017, configFilepath, field
								.getName(), field.getLength(), fileRecordMap.get(field.getName()),
						value));
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}

			// tH[}bgtB[hlZbg
			recordString.append(value);
		}

		return recordString.toString();
	}

	/**
	 * [t@CpXԂ܂B<br>
	 * @return [t@CpX
	 */
	public String getRuleFilepath() {
		if (ruleFilepath == null) {
			ruleFilepath = RecordFieldConstants.FIXED_LENGTH_FILE_WRITER_RULE_FILE_NAME;
		}
		return ruleFilepath;
	}

	/**
	 * [t@CpXݒ肵܂B<br>
	 * [t@CpXݒ肵ȂꍇAnullݒ肵ꍇ̓ftHg̃pX
	 * ({@link RecordFieldConstants#FIXED_LENGTH_FILE_WRITER_RULE_FILE_NAME})gp܂B
	 * @param path [t@CpX
	 */
	public void setRuleFilepath(String path) {
		ruleFilepath = path;
	}
}
