/*
 * XMLAttribute.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * XMLt@C̍ڂ̑\NXB
 * @author Daisuke Suga
 */
public class XMLAttribute {

	/** O */
	private static final Log LOG = LogFactory.getLog(XMLAttribute.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * ̖OB
	 */
	private String name = null;

	/**
	 * ̒lB
	 */
	private String value = null;

	/**
	 * ̖OԂURIB
	 */
	private String uri = "";

	/**
	 * QNameB
	 */
	private String qName = "";

	/**
	 * ڂ̖OB
	 */
	private String element = null;

	/**
	 * ANZbT̃L[B
	 */
	private String key = null;

	/**
	 * pXB
	 */
	private String path = null;

	/**
	 * RXgN^B
	 *
	 * @param name ̖O
	 * @param value ̒l
	 */
	public XMLAttribute(String name, Object value) {
		this(name, value, null, null, null);
	}

	/**
	 * RXgN^B
	 *
	 * @param name ̖O
	 * @param value ̒l
	 * @param element ڂ̖O
	 * @param key ANZbT̃L[
	 * @param path pX
	 */
	protected XMLAttribute(String name, Object value, String element, String key, String path) {
		this.name = name;
		this.value = value != null ? value.toString() : null;
		this.element = element;
		this.key = key;
		this.path = path;
	}

	/**
	 * ̖O擾܂B
	 *
	 * @return ̖O
	 */
	public String getName() {
		return name;
	}

	/**
	 * ̒lStringŎ擾܂B
	 *
	 * @return ̒l
	 */
	public String getString() {
		return value;
	}

	/**
	 * ̒lIntegerŎ擾܂B
	 *
	 * @return ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Integer getInteger() throws DataFormatException {
		try {
			return Integer.valueOf(value);
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_004
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_005;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_001, messageId, name, value, element,
					key, path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ̒lLongŎ擾܂B
	 *
	 * @return ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Long getLong() throws DataFormatException {
		try {
			return Long.valueOf(value);
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_004
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_005;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_002, messageId, name, value, element,
					key, path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ̒lFloatŎ擾܂B
	 *
	 * @return ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Float getFloat() throws DataFormatException {
		try {
			return Float.valueOf(value);
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_004
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_005;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_003, messageId, name, value, element,
					key, path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ̒lShortŎ擾܂B
	 *
	 * @return ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Short getShort() throws DataFormatException {
		try {
			return Short.valueOf(value);
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_004
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_005;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_004, messageId, name, value, element,
					key, path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ̒lBigDecimalŎ擾܂B
	 *
	 * @return ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public BigDecimal getBigDecimal() throws DataFormatException {
		try {
			return new BigDecimal(value);
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_004
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_005;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_005, messageId, name, value, element,
					key, path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ̒lDateŎ擾܂B
	 *
	 * @return ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Date getDate() throws DataFormatException {
		try {
			return DateFormat.getDateInstance().parse(value);
		} catch (ParseException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_004
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_005;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_006, messageId, name, value, element,
					key, path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ̖OԂURI擾܂B
	 *
	 * @return ̖OԂURI
	 */
	public String getURI() {
		return uri;
	}

	/**
	 * ̖OԂURIݒ肵܂B
	 *
	 * @param uri ̖OԂURI
	 */
	public void setURI(String uri) {
		this.uri = uri;
	}

	/**
	 * QName擾܂B
	 *
	 * @return QName
	 */
	public String getQName() {
		return qName;
	}

	/**
	 * QNameݒ肵܂B
	 *
	 * @param qName QName
	 */
	public void setQName(String qName) {
		this.qName = qName;
	}

	/**
	 * ̒lStringŎ擾܂B
	 * @return ڂ̒l
	 */
	public String toString() {
		return value;
	}

}
