/*
 * XMLAttributes.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * XMLt@C̍ڂׂ̂Ă̑\NXB
 * @author Daisuke Suga
 */
public class XMLAttributes {

	/**
	 * ̖OƑlێMapB
	 */
	private Map<String, XMLAttribute> attributeMap = new LinkedHashMap<String, XMLAttribute>();

	/**
	 * w肳ꂽ̖Oől擾܂B
	 * @param name ̖O
	 * @return 
	 */
	public XMLAttribute getAttribute(String name) {
		return attributeMap.get(name);
	}

	/**
	 * w肳ꂽlǉ܂B
	 * @param attribute 
	 */
	public void putAttribute(XMLAttribute attribute) {
		attributeMap.put(attribute.getName(), attribute);
	}

	/**
	 * 邩𔻒肵܂B
	 *
	 * @return ȂꍇtrueAꍇfalse
	 */
	public boolean isEmpty() {
		return attributeMap.isEmpty();
	}

	/**
	 * ̐擾܂B
	 *
	 * @return ̐
	 */
	public int size() {
		return attributeMap.size();
	}

	/**
	 * ̖OSet擾܂B
	 *
	 * @return ̖OSet
	 */
	public Set<String> keySet() {
		return attributeMap.keySet();
	}

	/**
	 * ̖OƒlSet擾܂B
	 *
	 * @return ̖OƒlSet
	 */
	public Set<Map.Entry<String, XMLAttribute>> entrySet() {
		return attributeMap.entrySet();
	}

	/**
	 * ̒lCollection擾܂B
	 *
	 * @return ̒lCollection
	 */
	public Collection<XMLAttribute> values() {
		return attributeMap.values();
	}

}
