/*
 * LoggingAspect.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.aspect;

import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

/**
 * g[XOo͂NXB<br>
 * SpringAspect@\gpăg[XOo͂܂B
 * Aspect@\̐ݒ̓gUNVReLXgitransactionContext.xmljɋLqĂ܂B
 * @author Naoko Sugimoto
 */
public class LoggingAspect {

	/** O */
	private static final Log LOG = LogFactory.getLog(LoggingAspect.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * g[XΏۂ̎sOɃbZ[Wo͂܂B<br>
	 * ʓIȃNXp̃g[XłB
	 * @param pjp g[XΏۂ̃WCgJbg|Cg
	 * @return g[XΏۂ̖߂l
	 * @throws Throwable g[XΏۂ瓊ꂽO
	 */
	public Object around(ProceedingJoinPoint pjp) throws Throwable {

		// sNX擾B
		String className = pjp.getTarget().getClass().getName();
		// \bh擾B
		String methodName = pjp.getSignature().getName();
		// Jn~bۑ
		long beforeTime = System.currentTimeMillis();

		// JnbZ[WóB
		LOG.info(MESSAGE.getMessage(LogMessageConstant.CB3_ASPECT_001, className, methodName));
		// fobOOɈ̒g\B
		if (LOG.isDebugEnabled()) {
			// \bh擾B
			Object[] args = pjp.getArgs();
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ASPECT_005, formatArguments(args)));
		}

		// \bhsB
		Object returnCode = pjp.proceed();

		// I~b擾B
		long afterTime = System.currentTimeMillis();
		// sԂ̎擾
		long execTime = afterTime - beforeTime;

		// IbZ[WóB
		LOG.info(MESSAGE.getMessage(LogMessageConstant.CB3_ASPECT_002, className, methodName, returnCode, execTime));

		return returnCode;
	}

	/**
	 * \bḧbZ[Wɕ\ł`ɕϊ܂B
	 * @param args \bḧ
	 * @return \bḧ𕶎񉻂
	 */
	private String formatArguments(Object[] args) {
		if (args == null || args.length == 0) {
			return "";
		}

		// \bḧbZ[Wɕ\ł`ɕϊB
		StringBuilder argsMessage = new StringBuilder();
		for (Object arg: args) {
			argsMessage.append(arg.toString());	// p[^\
			argsMessage.append(", ");
		}
		// ́u,v폜B
		if (argsMessage.length() > 0 && argsMessage.lastIndexOf(", ") == argsMessage.length() - 2) {
			argsMessage.delete(argsMessage.length() - 2, argsMessage.length());
		}
		return argsMessage.toString();
	}
}
