/*
 * ServiceLoggingAspect.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.aspect;

import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

/**
 * T[rX̃g[XOo͂NXB<br>
 * @author Naoko Sugimoto
 */
public class ServiceLoggingAspect {

	/** O */
	private static final Log LOG = LogFactory.getLog(ServiceLoggingAspect.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * T[rX̎sOɃbZ[Wo͂܂B<br>
	 * T[rXp̃g[XłB
	 * @param pjp T[rX̃WCg|Cg
	 * @return T[rX̏
	 * @throws Throwable T[rX瓊ꂽO
	 */
	public Object around(ProceedingJoinPoint pjp) throws Throwable {

		// sNX擾B
		String className = pjp.getTarget().getClass().getName();
		// \bh擾B
		Object[] args = pjp.getArgs();
		// Jn~bۑ
		long beforeTime = System.currentTimeMillis();

		// JnbZ[WóB
		LOG.info(MESSAGE.getMessage(LogMessageConstant.CB3_ASPECT_003, className, args[1]));
		// fobOOɈ̒g\B
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ASPECT_006, args[0]));
		}

		// T[rXsB
		Integer returnCode = (Integer)pjp.proceed();

		// I~b擾B
		long afterTime = System.currentTimeMillis();
		// sԂ̎擾
		long execTime = afterTime - beforeTime;

		// IbZ[WóB
		LOG.info(MESSAGE.getMessage(LogMessageConstant.CB3_ASPECT_004, className, returnCode, execTime));

		return returnCode;
	}
}
