/*
 * RuntimeArgumentsAnalyzer.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.session;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/**
 * t[[NN̈͂NXB<br>
 * ͂ANp[^擾܂B
 * @author Naoko Sugimoto
 */
public class RuntimeArgumentsAnalyzer {

	/**
	 * Np[^iCӕj̃L[B<br>
	 * ̃L[Ŏw肳ꂽ́A
	 * {@link RuntimeParameters}ƂăT[rXɈn܂B
	 */
	public static final String APP_PARAM_KEY = "-AppParams";

	/** Np[^iCӕj */
	private RuntimeParameters runtimeParameters = null;

	/**
	 * Np[^i\񕪁jB<br>
	 * u-ServiceNamevȂǁAt[[NŎgpp[^łB
	 */
	private Map<String, String> reservedParameters = new HashMap<String, String>();

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * RXgN^B
	 * @param args t[[NN̈
	 * @param parameterKeys \p[^L[̔z
	 */
	public RuntimeArgumentsAnalyzer(String[] args, String... parameterKeys) {
		analizeParameters(args, parameterKeys);
	}

	/**
	 * Np[^iCӕj擾܂B
	 *
	 * @return Np[^iCӕj
	 */
	public RuntimeParameters getRuntimeParameters() {
		return runtimeParameters;
	}

	/**
	 * Np[^i\񕪁j擾܂B
	 * @param key Np[^̃L[
	 * @return w肳ꂽL[ɊYNp[^i\񕪁j
	 */
	public String getReservedParameter(String key) {
		return reservedParameters.get(key);
	}

	/**
	 * AvP[VN̈͂ANp[^擾܂B<br>
	 * jF{-ReservedKey1, reservedValue1, -ReservedKey2, reservedValue2, ... , -AppParam, key1=value1, key2=value2}
	 * ̂ƂA͌ʂȉ̂悤reservedParametersAruntimeParametersɊi[܂B<br><br>
	 *   reservedParametersi\񕪁jFMap{-ReservedKey1=reservedValue1, -ReservedKey2=reservedValue2}<br>
	 *   runtimeParametersiCӕjFRuntimeParameters{key1=value1, key2=value2}<br>
	 * @param args AvP[VN̈
	 * @param reservedKeys \L[̔z
	 * TODO pbP[Wړ邩Athrows߂ɎsOLqB
	 */
	private void analizeParameters(String[] args, String... reservedKeys) {

		List<String> reservedKeyList = Arrays.asList(reservedKeys);
		Iterator<String> iterator = Arrays.asList(args).iterator();

		// Np[^i\񕪁j擾B
		while (iterator.hasNext()) {
			// Ƃ̏B
			String key = iterator.next();
			// \L[ꍇB
			if (reservedKeyList.contains(key)) {
				// ݂̈ꍇB
				if (iterator.hasNext()) {
					// Ɏ擾ς݂̗\L[łꍇAdĎw肳ĂߗOoB
					if (reservedParameters.containsKey(key)) {
						throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage(
								ErrorCodeConstant.SESSION_001, LogMessageConstant.CB3_SESSION_001,
								key));
					}
					// ̈p[^lƂ݂ȂAL[ƒlZbgŊi[B
					reservedParameters.put(key, iterator.next());

				// ݂̈ȂꍇB
				} else {
					// p[^lw肳ĂȂ߁AOoB
					throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage(
							ErrorCodeConstant.SESSION_002, LogMessageConstant.CB3_SESSION_002, key));
				}

			// AppParamL[ꍇB
			} else if (APP_PARAM_KEY.equals(key)) {
				// ȍ~͋Np[^iCӕjƂ݂ȂB
				break;

			// L[ł͂Ȃꍇ
			} else {
				// OoB
				throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.SESSION_003, LogMessageConstant.CB3_SESSION_003, key));
			}
		}

		// Np[^iCӕj擾B
		analyzeRuntimeParameters(iterator);
	}

	/**
	 * AvP[VN͂ANp[^iCӕj擾܂B
	 * Np[^iCӕjɓnꂽukey1=value1 key2=value2 ...v`̒l"="ŕAMapɊi[܂B
	 * @param iterator AvP[VÑCe[^BNp[^iCӕj̊JnʒuwB
	 */
	private void analyzeRuntimeParameters(Iterator<String> iterator) {
		Map<String, String> runtimeParameterMap = new HashMap<String, String>();
		while (iterator.hasNext()) {
			String runtimeParameter = iterator.next();

			// "="̈ʒu擾B
			int splitPoint = runtimeParameter.indexOf('=');
			// "="ȂꍇAOoB
			if (splitPoint < 0) {
				throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.SESSION_004, LogMessageConstant.CB3_SESSION_004,
						runtimeParameter));
			}

			// L[ƒl𕪊ă}bvɊi[B
			String key = runtimeParameter.substring(0, splitPoint);
			String value = runtimeParameter.substring(splitPoint + 1);
			runtimeParameterMap.put(key, value);
		}
		runtimeParameters = new RuntimeParameters(runtimeParameterMap);
	}
}
