/*
 * CB3BeanFactory.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * CB3ňBean𐶐t@NgNXB
 * @author Naoko Sugimoto
 */
public class CB3BeanFactory {

	/** CB3BeanFactory */
	private static CB3BeanFactory factory = new CB3BeanFactory();

	/** ftHg̃ReLXgt@CpX */
	private static final String APPLICATION_CONTEXT_FILEPATH = "applicationContext.xml";

	/** ReLXgt@CpX */
	private String applicationContextFilePath = null;

	/** AvP[VReLXg */
	private ApplicationContext context = null;

	/**
	 * CB3BeanFactory擾܂B
	 * @return CB3BeanFactory
	 */
	public static CB3BeanFactory getInstance() {
		return factory;
	}

	/**
	 * RXgN^B
	 */
	private CB3BeanFactory() {
	}

	/**
	 * Bean擾܂B
	 *
	 * @param beanId Bean ID
	 * @return Bean
	 */
	public Object getBean(String beanId) {
		if (context == null) {
			// AvP[VReLXg𐶐B
			createApplicationContext();
		}
		// AvP[VReLXgBean擾B
		return context.getBean(beanId);
	}

	/**
	 * AvP[VReLXg𐶐܂B
	 */
	private void createApplicationContext() {
		context = new ClassPathXmlApplicationContext(
				new String[]{
						getApplicationContextFilePath()
				}
		);
	}

	/**
	 * ANZbT[ReLXg̃t@CpX擾܂B
	 * @return ANZbT[ReLXg̃t@CpX
	 */
	public String getApplicationContextFilePath() {
		if (applicationContextFilePath == null) {
			applicationContextFilePath = APPLICATION_CONTEXT_FILEPATH;
		}
		return applicationContextFilePath;
	}

	/**
	 * ANZbT[ReLXg̃t@CpXݒ肵܂B
	 * @param filePath ANZbT[ReLXg̃t@CpX
	 */
	public void setApplicationContextFilePath(String filePath) {
		context = null;
		this.applicationContextFilePath = filePath;
	}
}
