/*
 * ConfigurationLoader.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.util;

import java.io.IOException;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.xml.sax.SAXException;

/**
 * ݒt@Cǂݍނ߂̃[eBeBNXB<br>
 * digestergpĐݒt@Cǂݍ݂܂B
 * @author Daisuke Suga
 */
public class ConfigurationLoader {

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** `t@C̊gq */
	private static final String EXTENSION_XML = "xml";

	/**
	 * ݒt@Cǂݍ݂܂B
	 *
	 * @param rule digester̃[t@C
	 * @param config ݒt@C
	 * @throws ConfigFileNotFoundException ݒt@C݂Ȃꍇɔ܂B
	 * @throws ConfigFileDefinitionException ݒt@C̊ԈႢɂ蔭܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 * @return ǂݍ݌ʁBIuWFNǧ^́A[t@Cɒ`܂B
	 */
	public static Object load(String rule, String config) throws ConfigFileNotFoundException,
			ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {

		String ruleFile = toFileName(rule);
		String configFile = toFileName(config);

		// digester̃[t@CURL擾܂B
		URL ruleUrl = ConfigurationLoader.class.getClassLoader().getResource(ruleFile);
		if (ruleUrl == null) {
			throw new ConfigFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.UTIL_001, LogMessageConstant.CB3_UTIL_006, rule));
		}

		// ݒt@CURL擾܂B
		URL configUrl = ConfigurationLoader.class.getClassLoader().getResource(configFile);
		if (configUrl == null) {
			throw new ConfigFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.UTIL_002, LogMessageConstant.CB3_UTIL_006, config));
		}

		// ݒt@Cǂݍ݂܂B
		return load(ruleUrl, configUrl);
	}

	/**
	 * ݒt@Cǂݍ݂܂B
	 *
	 * @param rule digester̃[t@C
	 * @param config ݒt@C
	 * @throws ConfigFileDefinitionException ݒt@C̐ݒ肪ԈĂꍇɔ܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 * @return ǂݍ݌ʁBIuWFNǧ^́A[t@Cɒ`܂B
	 */
	public static Object load(URL rule, URL config) throws ConfigFileDefinitionException,
			ConfigFileIOException, ConfigFileParseException {

		try {
			// Digester̍쐬Ɛݒ
			Digester digester = DigesterLoader.createDigester(rule);
			digester.setNamespaceAware(true);
			digester.setValidating(true);
			digester.setUseContextClassLoader(true);
			digester.setFeature("http://xml.org/sax/features/validation", true);
			digester.setFeature("http://apache.org/xml/features/validation/schema",true);
			digester.setFeature("http://xml.org/sax/features/namespaces",true);

			// Ó؃G[nhݒ
			ValidationErrorHandler myErrorHandler = new ValidationErrorHandler();
			digester.setErrorHandler(myErrorHandler);

			// XMLXL[}GeBeBݒ
			ValidationEntityResolver schemaResolver = new ValidationEntityResolver();
			schemaResolver.setXmlFile(config);
			digester.setEntityResolver(schemaResolver);

			// XMLt@Cp[T
			Object object = digester.parse(config);

			// Ó؂G[̏ꍇ
			if (!myErrorHandler.isValid()) {
				throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.UTIL_003, LogMessageConstant.CB3_UTIL_002, config));
			}

			// p[TɎsꍇ
			if (object == null) {
				throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.UTIL_004, LogMessageConstant.CB3_UTIL_003, config));
			}

			return object;

		} catch (IOException e) {
			throw new ConfigFileIOException(MESSAGE.getErrorMessage(ErrorCodeConstant.UTIL_005,
					LogMessageConstant.CB3_UTIL_003, config), e);
		} catch (SAXException e) {
			throw new ConfigFileParseException(MESSAGE.getErrorMessage(ErrorCodeConstant.UTIL_006,
					LogMessageConstant.CB3_UTIL_004, config), e);
		} catch (XmlLoadException e) {
			throw new ConfigFileParseException(MESSAGE.getErrorMessage(ErrorCodeConstant.UTIL_007,
					LogMessageConstant.CB3_UTIL_004, config), e);
		} catch (ParserConfigurationException e) {
			throw new ConfigFileParseException(MESSAGE.getErrorMessage(ErrorCodeConstant.UTIL_008,
					LogMessageConstant.CB3_UTIL_004, config), e);
		}
	}

	/**
	 * ANZbT̃L[t@Cɕϊĕԋp܂B
	 *
	 * @param value ANZbT̃L[
	 * @return t@CiL[Ɋgqtj
	 */
	private static String toFileName(String value) {

		String filename = value;

		// gq擾
		String extension = null;
		int point = filename.lastIndexOf(".");
		if (point != -1) {
			extension = filename.substring(point + 1);
		}

		// gqȂꍇuxmlvłȂꍇꍇ́Au.xmlvt
		if (extension == null || !extension.equalsIgnoreCase(EXTENSION_XML)) {
			filename = filename + "." + EXTENSION_XML;
		}

		return filename;
	}
}
